/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantNullableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class RedundantNullableChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final RedundantNullableChecker INSTANCE = new RedundantNullableChecker();

    private RedundantNullableChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!ConeTypeUtilsKt.isMarkedNullable(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(typeRef.getConeType()))) break block10;
                KtSourceElement ktSourceElement = typeRef.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitTypeArgument.INSTANCE)) break block11;
            }
            return;
        }
        FirClassifierSymbol symbol = ToSymbolUtilsKt.toSymbol(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(typeRef.getConeType()), context.getSession());
        if (symbol instanceof FirTypeAliasSymbol) {
            while (symbol instanceof FirTypeAliasSymbol) {
                FirResolvedTypeRef resolvedExpandedTypeRef = ((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef();
                if (ConeTypeUtilsKt.isMarkedNullable(resolvedExpandedTypeRef.getConeType())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getREDUNDANT_NULLABLE(), (DiagnosticContext)context, null, 8, null);
                    break;
                }
                symbol = FirHelpersKt.toClassLikeSymbol(resolvedExpandedTypeRef, context.getSession());
            }
        } else {
            SourceNavigator $this$check_u24lambda_u240 = SourceNavigator.Companion.forElement(typeRef);
            boolean bl = false;
            if ($this$check_u24lambda_u240.isRedundantNullable(typeRef)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getREDUNDANT_NULLABLE(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }
}

