/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import javax.annotation.Nullable;

final class AdaptingIntegerArray {
    @Nullable
    private byte[] byteBacking;
    @Nullable
    private short[] shortBacking;
    @Nullable
    private int[] intBacking;
    @Nullable
    private long[] longBacking;
    private ArrayCellSize cellSize;

    AdaptingIntegerArray(int size) {
        this.cellSize = ArrayCellSize.BYTE;
        this.byteBacking = new byte[size];
    }

    private AdaptingIntegerArray(AdaptingIntegerArray toCopy) {
        this.cellSize = toCopy.cellSize;
        switch (this.cellSize) {
            case BYTE: {
                this.byteBacking = Arrays.copyOf(toCopy.byteBacking, toCopy.byteBacking.length);
                break;
            }
            case SHORT: {
                this.shortBacking = Arrays.copyOf(toCopy.shortBacking, toCopy.shortBacking.length);
                break;
            }
            case INT: {
                this.intBacking = Arrays.copyOf(toCopy.intBacking, toCopy.intBacking.length);
                break;
            }
            case LONG: {
                this.longBacking = Arrays.copyOf(toCopy.longBacking, toCopy.longBacking.length);
            }
        }
    }

    AdaptingIntegerArray copy() {
        return new AdaptingIntegerArray(this);
    }

    void increment(int idx, long count2) {
        switch (this.cellSize) {
            case BYTE: {
                long result2 = (long)this.byteBacking[idx] + count2;
                if (result2 > 127L) {
                    this.resizeToShort();
                    this.increment(idx, count2);
                    return;
                }
                this.byteBacking[idx] = (byte)result2;
                return;
            }
            case SHORT: {
                long result3 = (long)this.shortBacking[idx] + count2;
                if (result3 > 32767L) {
                    this.resizeToInt();
                    this.increment(idx, count2);
                    return;
                }
                this.shortBacking[idx] = (short)result3;
                return;
            }
            case INT: {
                long result4 = (long)this.intBacking[idx] + count2;
                if (result4 > Integer.MAX_VALUE) {
                    this.resizeToLong();
                    this.increment(idx, count2);
                    return;
                }
                this.intBacking[idx] = (int)result4;
                return;
            }
            case LONG: {
                this.longBacking[idx] = this.longBacking[idx] + count2;
                return;
            }
        }
    }

    long get(int index) {
        long value = 0L;
        switch (this.cellSize) {
            case BYTE: {
                value = this.byteBacking[index];
                break;
            }
            case SHORT: {
                value = this.shortBacking[index];
                break;
            }
            case INT: {
                value = this.intBacking[index];
                break;
            }
            case LONG: {
                value = this.longBacking[index];
            }
        }
        return value;
    }

    int length() {
        int length = 0;
        switch (this.cellSize) {
            case BYTE: {
                length = this.byteBacking.length;
                break;
            }
            case SHORT: {
                length = this.shortBacking.length;
                break;
            }
            case INT: {
                length = this.intBacking.length;
                break;
            }
            case LONG: {
                length = this.longBacking.length;
            }
        }
        return length;
    }

    void clear() {
        switch (this.cellSize) {
            case BYTE: {
                Arrays.fill(this.byteBacking, (byte)0);
                break;
            }
            case SHORT: {
                Arrays.fill(this.shortBacking, (short)0);
                break;
            }
            case INT: {
                Arrays.fill(this.intBacking, 0);
                break;
            }
            case LONG: {
                Arrays.fill(this.longBacking, 0L);
            }
        }
    }

    private void resizeToShort() {
        short[] shortBacking = new short[this.byteBacking.length];
        for (int i = 0; i < this.byteBacking.length; ++i) {
            shortBacking[i] = this.byteBacking[i];
        }
        this.cellSize = ArrayCellSize.SHORT;
        this.shortBacking = shortBacking;
        this.byteBacking = null;
    }

    private void resizeToInt() {
        int[] intBacking = new int[this.shortBacking.length];
        for (int i = 0; i < this.shortBacking.length; ++i) {
            intBacking[i] = this.shortBacking[i];
        }
        this.cellSize = ArrayCellSize.INT;
        this.intBacking = intBacking;
        this.shortBacking = null;
    }

    private void resizeToLong() {
        long[] longBacking = new long[this.intBacking.length];
        for (int i = 0; i < this.intBacking.length; ++i) {
            longBacking[i] = this.intBacking[i];
        }
        this.cellSize = ArrayCellSize.LONG;
        this.longBacking = longBacking;
        this.intBacking = null;
    }

    private static enum ArrayCellSize {
        BYTE,
        SHORT,
        INT,
        LONG;

    }
}

