/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsGlobalFileEntitySource;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.jps.entities.SdkRoot;
import com.intellij.platform.workspace.jps.entities.SdkRootTypeId;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.jps.serialization.impl.JpsSdkEntitySerializerKt;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJH\u0010\"\u001a*\u0012&\u0012$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0\u001f\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0'0&0$0#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u001e\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00062\u0006\u00104\u001a\u0002012\u0006\u0010,\u001a\u00020-H\u0002JB\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082(\u0010:\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0\u001f\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0'0&0$H\u0016JH\u0010;\u001a\u0002062\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020&2 \u0010=\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u00060$2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u0016\u0010B\u001a\u0002062\u0006\u0010C\u001a\u0002012\u0006\u0010D\u001a\u00020\u0002J\u0016\u0010B\u001a\u0002062\u0006\u0010C\u001a\u0002012\u0006\u0010D\u001a\u00020/JJ\u0010B\u001a\u0002062\u0006\u0010C\u001a\u0002012\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u00072\b\u0010G\u001a\u0004\u0018\u00010\u00072\b\u0010H\u001a\u0004\u0018\u00010\u001b2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002030\u00062\u0006\u0010J\u001a\u00020\u0007H\u0002J\u001e\u0010K\u001a\u0002012\u0006\u0010L\u001a\u00020\u00072\f\u0010M\u001a\b\u0012\u0004\u0012\u0002030\u0006H\u0002J\u0018\u0010N\u001a\u0002062\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010@\u001a\u00020AH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000e\u001a#\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006O"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/jps/entities/SdkEntity;", "entitySource", "Lcom/intellij/platform/workspace/jps/JpsGlobalFileEntitySource;", "sortedRootTypes", "", "", "<init>", "(Lcom/intellij/platform/workspace/jps/JpsGlobalFileEntitySource;Ljava/util/List;)V", "getEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsGlobalFileEntitySource;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "rootTypes", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/workspace/jps/entities/SdkRootTypeId;", "Lorg/jetbrains/annotations/NotNull;", "isExternalStorage", "", "()Z", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "loadSdkEntity", "Lcom/intellij/platform/workspace/jps/entities/SdkEntity$Builder;", "sdkElement", "Lorg/jdom/Element;", "readRoots", "Lcom/intellij/platform/workspace/jps/entities/SdkRoot;", "rootsElement", "checkAndAddToBuilder", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "saveEntities", "mainEntities", "entities", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "saveSdkEntity", "sdkRootElement", "sdkEntity", "sdkName", "sdkType", "sdkVersion", "sdkHomePath", "sdkRoots", "sdkAdditionalData", "writeRoots", "rootType", "roots", "deleteObsoleteFile", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsSdkEntitySerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsSdkEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,223:1\n14#2:224\n1557#3:225\n1628#3,3:226\n1863#3,2:229\n1863#3,2:231\n1485#3:233\n1510#3,3:234\n1513#3,3:244\n1863#3,2:247\n1863#3,2:249\n381#4,7:237\n*S KotlinDebug\n*F\n+ 1 JpsSdkEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer\n*L\n56#1:224\n74#1:225\n74#1:226,3\n130#1:229,2\n136#1:231,2\n193#1:233\n193#1:234,3\n193#1:244,3\n195#1:247,2\n209#1:249,2\n193#1:237,7\n*E\n"})
public final class JpsSdkEntitySerializer
implements JpsFileEntityTypeSerializer<SdkEntity> {
    @NotNull
    private final JpsGlobalFileEntitySource entitySource;
    @NotNull
    private final List<String> sortedRootTypes;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ConcurrentMap<String, SdkRootTypeId> rootTypes;

    public JpsSdkEntitySerializer(@NotNull JpsGlobalFileEntitySource entitySource, @NotNull List<String> sortedRootTypes) {
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        Intrinsics.checkNotNullParameter(sortedRootTypes, (String)"sortedRootTypes");
        this.entitySource = entitySource;
        this.sortedRootTypes = sortedRootTypes;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JpsSdkEntitySerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        ConcurrentMap<Object, SdkRootTypeId> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> JpsSdkEntitySerializer.rootTypes$lambda$1(JpsSdkEntitySerializer::rootTypes$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createMap(...)");
        this.rootTypes = concurrentMap;
    }

    @NotNull
    public final JpsGlobalFileEntitySource getEntitySource() {
        return this.entitySource;
    }

    @Override
    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.entitySource;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.entitySource.getFile();
    }

    @Override
    @NotNull
    public Class<SdkEntity> getMainEntityClass() {
        return SdkEntity.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        String string = this.entitySource.getFile().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        Element element = JpsFileContentReader.loadComponent$default(reader, string, "ProjectJdkTable", null, 4, null);
        if (element == null) {
            return new LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>>(MapsKt.emptyMap(), null);
        }
        Element sdkTag = element;
        List<Element> list = sdkTag.getChildren("jdk");
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sdkElement;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)sdkElement);
            collection.add(this.loadSdkEntity((Element)sdkElement, virtualFileManager));
        }
        List sdkEntities = (List)destination$iv$iv;
        return new LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>>(MapsKt.mapOf((Pair)TuplesKt.to(SdkEntity.class, (Object)sdkEntities)), null, 2, null);
    }

    @NotNull
    public final SdkEntity.Builder loadSdkEntity(@NotNull Element sdkElement, @NotNull VirtualFileUrlManager virtualFileManager) {
        Element additionalDataElement;
        Intrinsics.checkNotNullParameter((Object)sdkElement, (String)"sdkElement");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        String sdkName = sdkElement.getChild("name").getAttributeValue("value");
        String sdkType = sdkElement.getChild("type").getAttributeValue("value");
        String versionValue = sdkElement.getAttributeValue(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p());
        if (!Intrinsics.areEqual((Object)"2", (Object)versionValue)) {
            throw new InvalidDataException("Too old version is not supported: " + versionValue);
        }
        Element element = sdkElement.getChild(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p());
        String sdkVersion = element != null ? element.getAttributeValue("value") : null;
        Element element2 = sdkElement.getChild(JpsSdkEntitySerializerKt.access$getELEMENT_HOMEPATH$p());
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"getChild(...)");
        String homePath = JpsProjectSerializersImplKt.getAttributeValueStrict(element2, "value");
        VirtualFileUrl homePathVfu = virtualFileManager.getOrCreateFromUrl(homePath);
        List<SdkRoot> roots = this.readRoots(JpsProjectSerializersImplKt.getChildTagStrict(sdkElement, JpsSdkEntitySerializerKt.access$getELEMENT_ROOTS$p()), virtualFileManager);
        Element element3 = additionalDataElement = sdkElement.getChild("additional");
        String string = element3 != null ? JDOMUtil.write(element3) : "";
        Intrinsics.checkNotNull((Object)string);
        String additionalData = string;
        Intrinsics.checkNotNull((Object)sdkName);
        Intrinsics.checkNotNull((Object)sdkType);
        return SdkEntity.Companion.create(sdkName, sdkType, roots, additionalData, this.entitySource, (Function1<? super SdkEntity.Builder, Unit>)((Function1)arg_0 -> JpsSdkEntitySerializer.loadSdkEntity$lambda$3(homePathVfu, sdkVersion, arg_0)));
    }

    private final List<SdkRoot> readRoots(Element rootsElement, VirtualFileUrlManager virtualFileManager) {
        List result2 = new ArrayList();
        for (Element rootElement : rootsElement.getChildren()) {
            String rootType = rootElement.getName();
            List<Element> composites = rootElement.getChildren();
            if (composites.size() != 1) {
                this.LOG.error("Single child expected by " + composites + " found");
            }
            Element composite = composites.get(0);
            for (Element rootTag : composite.getChildren("root")) {
                Intrinsics.checkNotNull((Object)rootTag);
                String url = JpsProjectSerializersImplKt.getAttributeValueStrict(rootTag, "url");
                VirtualFileUrl virtualFileUrl = virtualFileManager.getOrCreateFromUrl(url);
                Object v = this.rootTypes.get(rootType);
                Intrinsics.checkNotNull(v);
                result2.add(new SdkRoot(virtualFileUrl, (SdkRootTypeId)v));
            }
        }
        return result2;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> newEntities) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)orphanage, (String)"orphanage");
        Intrinsics.checkNotNullParameter(newEntities, (String)"newEntities");
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)newEntities.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity.Builder it = (WorkspaceEntity.Builder)element$iv;
            boolean bl = false;
            builder.addEntity(it);
        }
    }

    @Override
    public void saveEntities(@NotNull Collection<? extends SdkEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, (String)"mainEntities");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Element componentTag2 = JDomSerializationUtil.createComponentElement("ProjectJdkTable");
        Iterable $this$forEach$iv = mainEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkEntity sdkEntity = (SdkEntity)element$iv;
            boolean bl = false;
            Element sdkElement = new Element("jdk");
            this.saveSdkEntity(sdkElement, sdkEntity);
            componentTag2.addContent(sdkElement);
        }
        String string = this.getFileUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        writer.saveComponent(string, "ProjectJdkTable", componentTag2);
    }

    public final void saveSdkEntity(@NotNull Element sdkRootElement, @NotNull SdkEntity sdkEntity) {
        Intrinsics.checkNotNullParameter((Object)sdkRootElement, (String)"sdkRootElement");
        Intrinsics.checkNotNullParameter((Object)sdkEntity, (String)"sdkEntity");
        this.saveSdkEntity(sdkRootElement, sdkEntity.getName(), sdkEntity.getType(), sdkEntity.getVersion(), sdkEntity.getHomePath(), sdkEntity.getRoots(), sdkEntity.getAdditionalData());
    }

    public final void saveSdkEntity(@NotNull Element sdkRootElement, @NotNull SdkEntity.Builder sdkEntity) {
        Intrinsics.checkNotNullParameter((Object)sdkRootElement, (String)"sdkRootElement");
        Intrinsics.checkNotNullParameter((Object)sdkEntity, (String)"sdkEntity");
        this.saveSdkEntity(sdkRootElement, sdkEntity.getName(), sdkEntity.getType(), sdkEntity.getVersion(), sdkEntity.getHomePath(), sdkEntity.getRoots(), sdkEntity.getAdditionalData());
    }

    /*
     * WARNING - void declaration
     */
    private final void saveSdkEntity(Element sdkRootElement, String sdkName, String sdkType, String sdkVersion, VirtualFileUrl sdkHomePath, List<SdkRoot> sdkRoots, String sdkAdditionalData) {
        void $this$groupByTo$iv$iv;
        sdkRootElement.setAttribute(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p(), "2");
        Element name = new Element("name");
        name.setAttribute("value", sdkName);
        sdkRootElement.addContent(name);
        String it = sdkType;
        boolean bl = false;
        Element mySdkType = new Element("type");
        mySdkType.setAttribute("value", it);
        sdkRootElement.addContent(mySdkType);
        String string = sdkVersion;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            Element version = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p());
            version.setAttribute("value", it);
            sdkRootElement.addContent(version);
        }
        Element home = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_HOMEPATH$p());
        VirtualFileUrl virtualFileUrl = sdkHomePath;
        home.setAttribute("value", virtualFileUrl != null ? virtualFileUrl.getUrl() : null);
        sdkRootElement.addContent(home);
        Iterable $this$groupBy$iv = sdkRoots;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SdkRoot it2 = (SdkRoot)element$iv$iv;
            boolean bl3 = false;
            String key$iv$iv = it2.getType().getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap sortedRoots = MapsKt.toSortedMap((Map)destination$iv$iv);
        Element rootsElement = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_ROOTS$p());
        Iterable $this$forEach$iv = this.sortedRootTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String rootType = (String)element$iv;
            boolean bl5 = false;
            List list = (List)sortedRoots.get(rootType);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List mySdkRoots = list;
            rootsElement.addContent(this.writeRoots(rootType, mySdkRoots));
        }
        sdkRootElement.addContent(rootsElement);
        if (!StringsKt.isBlank((CharSequence)sdkAdditionalData)) {
            sdkRootElement.addContent(JDOMUtil.load(sdkAdditionalData));
        }
    }

    private final Element writeRoots(String rootType, List<SdkRoot> roots) {
        Element composite = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_ROOT$p());
        composite.setAttribute("type", "composite");
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkRoot root = (SdkRoot)element$iv;
            boolean bl = false;
            Element rootElement = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_ROOT$p());
            rootElement.setAttribute("url", root.getUrl().getUrl());
            rootElement.setAttribute("type", "simple");
            composite.addContent(rootElement);
        }
        Element element = new Element(rootType);
        element.addContent(composite);
        return element;
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.saveComponent(fileUrl, "ProjectJdkTable", null);
    }

    private static final SdkRootTypeId rootTypes$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return new SdkRootTypeId(it);
    }

    private static final SdkRootTypeId rootTypes$lambda$1(Function1 $tmp0, Object p0) {
        return (SdkRootTypeId)$tmp0.invoke(p0);
    }

    private static final Unit loadSdkEntity$lambda$3(VirtualFileUrl $homePathVfu, String $sdkVersion, SdkEntity.Builder $this$SdkEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$SdkEntity, (String)"$this$SdkEntity");
        $this$SdkEntity.setHomePath($homePathVfu);
        $this$SdkEntity.setVersion($sdkVersion);
        return Unit.INSTANCE;
    }
}

