/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2;

import com.android.tools.smali.util.ExceptionWithContext;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import javax.annotation.Nonnull;

public class MethodHandleType {
    public static final int STATIC_PUT = 0;
    public static final int STATIC_GET = 1;
    public static final int INSTANCE_PUT = 2;
    public static final int INSTANCE_GET = 3;
    public static final int INVOKE_STATIC = 4;
    public static final int INVOKE_INSTANCE = 5;
    public static final int INVOKE_CONSTRUCTOR = 6;
    public static final int INVOKE_DIRECT = 7;
    public static final int INVOKE_INTERFACE = 8;
    private static final BiMap<Integer, String> methodHandleTypeNames = new ImmutableBiMap.Builder().put((Object)0, (Object)"static-put").put((Object)1, (Object)"static-get").put((Object)2, (Object)"instance-put").put((Object)3, (Object)"instance-get").put((Object)4, (Object)"invoke-static").put((Object)5, (Object)"invoke-instance").put((Object)6, (Object)"invoke-constructor").put((Object)7, (Object)"invoke-direct").put((Object)8, (Object)"invoke-interface").build();

    @Nonnull
    public static String toString(int methodHandleType) {
        String val = (String)methodHandleTypeNames.get((Object)methodHandleType);
        if (val == null) {
            throw new InvalidMethodHandleTypeException(methodHandleType);
        }
        return val;
    }

    public static int getMethodHandleType(String methodHandleType) {
        Integer ret = (Integer)methodHandleTypeNames.inverse().get((Object)methodHandleType);
        if (ret == null) {
            throw new ExceptionWithContext("Invalid method handle type: %s", methodHandleType);
        }
        return ret;
    }

    public static class InvalidMethodHandleTypeException
    extends ExceptionWithContext {
        private final int methodHandleType;

        public InvalidMethodHandleTypeException(int methodHandleType) {
            super("Invalid method handle type: %d", methodHandleType);
            this.methodHandleType = methodHandleType;
        }

        public InvalidMethodHandleTypeException(int methodHandleType, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.methodHandleType = methodHandleType;
        }

        public int getMethodHandleType() {
            return this.methodHandleType;
        }
    }
}

