/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.DeltaGenerator;
import com.google.archivepatcher.generator.PatchWriter;
import com.google.archivepatcher.generator.PreDiffExecutor;
import com.google.archivepatcher.generator.PreDiffPlan;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.generator.TempFileHolder;
import com.google.archivepatcher.generator.bsdiff.BsDiffDeltaGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileByFileV1DeltaGenerator
implements DeltaGenerator {
    private final List<RecommendationModifier> recommendationModifiers;

    public FileByFileV1DeltaGenerator(RecommendationModifier ... recommendationModifiers) {
        this.recommendationModifiers = recommendationModifiers != null ? Collections.unmodifiableList(Arrays.asList(recommendationModifiers)) : Collections.emptyList();
    }

    @Override
    public void generateDelta(File oldFile, File newFile, OutputStream patchOut) throws IOException, InterruptedException {
        try (TempFileHolder deltaFriendlyOldFile = new TempFileHolder();
             TempFileHolder deltaFriendlyNewFile = new TempFileHolder();
             TempFileHolder deltaFile = new TempFileHolder();
             FileOutputStream deltaFileOut = new FileOutputStream(deltaFile.file);
             BufferedOutputStream bufferedDeltaOut = new BufferedOutputStream(deltaFileOut);){
            PreDiffExecutor.Builder builder = new PreDiffExecutor.Builder().readingOriginalFiles(oldFile, newFile).writingDeltaFriendlyFiles(deltaFriendlyOldFile.file, deltaFriendlyNewFile.file);
            for (RecommendationModifier modifier : this.recommendationModifiers) {
                builder.withRecommendationModifier(modifier);
            }
            PreDiffExecutor executor = builder.build();
            PreDiffPlan preDiffPlan = executor.prepareForDiffing();
            DeltaGenerator deltaGenerator = this.getDeltaGenerator();
            deltaGenerator.generateDelta(deltaFriendlyOldFile.file, deltaFriendlyNewFile.file, bufferedDeltaOut);
            bufferedDeltaOut.close();
            PatchWriter patchWriter = new PatchWriter(preDiffPlan, deltaFriendlyOldFile.file.length(), deltaFriendlyNewFile.file.length(), deltaFile.file);
            patchWriter.writeV1Patch(patchOut);
        }
    }

    protected DeltaGenerator getDeltaGenerator() {
        return new BsDiffDeltaGenerator();
    }
}

