/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirExpressionJavaNullabilityWarningCheckersKt;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedTypeForWarningAttributeKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirQualifiedAccessJavaNullabilityWarningChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "buildSubstitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirExpressionJavaNullabilityWarningCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionJavaNullabilityWarningCheckers.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirQualifiedAccessJavaNullabilityWarningChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,200:1\n1#2:201\n57#3,4:202\n216#4,2:206\n*S KotlinDebug\n*F\n+ 1 FirExpressionJavaNullabilityWarningCheckers.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirQualifiedAccessJavaNullabilityWarningChecker\n*L\n66#1:202,4\n66#1:206,2\n*E\n"})
public final class FirQualifiedAccessJavaNullabilityWarningChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirQualifiedAccessJavaNullabilityWarningChecker INSTANCE = new FirQualifiedAccessJavaNullabilityWarningChecker();

    private FirQualifiedAccessJavaNullabilityWarningChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block10: {
            FirPureAbstractElement firPureAbstractElement;
            ConeKotlinType receiverType;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> symbol = firCallableSymbol;
            ConeSubstitutor substitutor2 = this.buildSubstitutor(expression2, symbol, context.getSession());
            if (symbol.getDispatchReceiverType() != null) {
                Object object = expression2.getDispatchReceiver();
                boolean bl = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null && (object = EnhancedTypeForWarningAttributeKt.getEnhancedTypeForWarning((ConeKotlinType)object)) != null ? ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)object) : false;
                if (bl) {
                    FirExpression firExpression = expression2.getDispatchReceiver();
                    if (firExpression != null) {
                        FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(firExpression, symbol.getDispatchReceiverType(), reporter, context, FirJvmErrors.INSTANCE.getRECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
                    }
                }
            }
            ConeKotlinType coneKotlinType = receiverType = (firPureAbstractElement = symbol.getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null;
            FirExpression firExpression = expression2.getExtensionReceiver();
            if (firExpression != null) {
                ConeKotlinType coneKotlinType2;
                ConeKotlinType coneKotlinType3 = receiverType;
                if (coneKotlinType3 != null) {
                    void p0;
                    ConeKotlinType coneKotlinType4 = coneKotlinType3;
                    FirExpression firExpression2 = firExpression;
                    boolean bl = false;
                    coneKotlinType2 = substitutor2.substituteOrSelf((ConeKotlinType)p0);
                    firExpression = firExpression2;
                } else {
                    coneKotlinType2 = null;
                }
                FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(firExpression, coneKotlinType2, reporter, context, FirJvmErrors.INSTANCE.getRECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
            }
            for (Pair pair : CollectionsKt.zip((Iterable)expression2.getContextReceiverArguments(), (Iterable)symbol.getResolvedContextReceivers())) {
                FirExpression contextArgument = (FirExpression)pair.component1();
                FirContextReceiver contextParameter = (FirContextReceiver)pair.component2();
                FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(contextArgument, substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(contextParameter.getTypeRef())), reporter, context, FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
            }
            if (!(expression2 instanceof FirFunctionCall)) break block10;
            FirCall $this$resolvedArgumentMapping$iv = (FirCall)((Object)expression2);
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap != null) {
                Map $this$forEach$iv = linkedHashMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    FirExpression argument = (FirExpression)entry.getKey();
                    FirValueParameter parameter = (FirValueParameter)entry.getValue();
                    FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(argument, substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())), reporter, context, FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
                }
            }
        }
    }

    private final ConeSubstitutor buildSubstitutor(FirQualifiedAccessExpression expression2, FirCallableSymbol<?> symbol, FirSession session2) {
        Map map;
        if (expression2.getTypeArguments().isEmpty()) {
            return ConeSubstitutor.Empty.INSTANCE;
        }
        Map $this$buildSubstitutor_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Pair pair : CollectionsKt.zip((Iterable)symbol.getTypeParameterSymbols(), (Iterable)expression2.getTypeArguments())) {
            FirTypeParameterSymbol parameter = (FirTypeParameterSymbol)pair.component1();
            FirTypeProjection argument = (FirTypeProjection)pair.component2();
            if (!(argument instanceof FirTypeProjectionWithVariance)) continue;
            $this$buildSubstitutor_u24lambda_u241.put(parameter, FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)argument).getTypeRef()));
        }
        Map substitutionMap = MapsKt.build((Map)map);
        return ConeSubstitutorByMapKt.substitutorByMap$default(substitutionMap, session2, false, 4, null);
    }
}

