/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.PathUtils;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ArchivePathEntry
extends ArchiveEntry {
    private long rawFileSize = -1L;
    private long downloadFileSize = -1L;
    private ZipEntryInfo.Alignment alignment = ZipEntryInfo.Alignment.ALIGNMENT_NONE;
    private boolean isCompressed = false;

    public ArchivePathEntry(Archive archive, Path path, String pathPrefix) {
        super(archive, path, pathPrefix);
    }

    @Override
    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    @Override
    public void setFileAlignment(ZipEntryInfo.Alignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public ZipEntryInfo.Alignment getFileAlignment() {
        return this.alignment;
    }

    @Override
    public void setIsFileCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public boolean isFileCompressed() {
        return !Files.isDirectory(this.getPath(), new LinkOption[0]) && this.isCompressed;
    }

    @Override
    public long getRawFileSize() {
        return this.rawFileSize;
    }

    @Override
    public void setDownloadFileSize(long downloadFileSize) {
        this.downloadFileSize = downloadFileSize;
    }

    @Override
    public long getDownloadFileSize() {
        return this.downloadFileSize;
    }

    @Override
    public String getNodeDisplayString() {
        Path base = this.getPath().getFileName();
        String name = base == null ? "" : base.toString();
        return ArchivePathEntry.trimEnd(name, "/");
    }

    @Override
    public String getSummaryDisplayString() {
        return this.getPathPrefix() + PathUtils.pathWithTrailingSeparator(this.getPath());
    }

    private static String trimEnd(String s, String suffix) {
        boolean endsWith = s.endsWith(suffix);
        if (endsWith) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }
}

