/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.lint.LintResourceItem;
import com.android.tools.lint.LintResourcePersistence;
import com.android.tools.lint.LintResourceRepository;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.PathVariables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J8\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\rJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/LintResourcePersistence;", "", "<init>", "()V", "serialize", "", "repository", "Lcom/android/tools/lint/LintResourceRepository;", "pathVariables", "Lcom/android/tools/lint/model/PathVariables;", "root", "Ljava/io/File;", "sort", "", "encodeLineColumnOffset", "", "line", "", "column", "offset", "decodeLine", "bits", "decodeColumn", "decodeOffset", "deserialize", "s", "project", "Lcom/android/tools/lint/detector/api/Project;", "allowMissingPathVariable", "SerializationWriter", "DeserializationReader", "LintDeserializedResourceItem", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nLintResourcePersistence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence$DeserializationReader\n*L\n1#1,832:1\n1#2:833\n440#3:834\n355#3,4:835\n440#3:839\n355#3,4:840\n436#3,2:844\n440#3:846\n355#3,4:847\n436#3,2:851\n428#3,2:853\n355#3,4:855\n431#3:859\n355#3,4:860\n436#3,2:864\n355#3,4:866\n*S KotlinDebug\n*F\n+ 1 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence\n*L\n474#1:834\n474#1:835,4\n499#1:839\n501#1:840,4\n502#1:844,2\n503#1:846\n508#1:847,4\n509#1:851,2\n520#1:853,2\n520#1:855,4\n520#1:859\n546#1:860,4\n550#1:864,2\n553#1:866,4\n*E\n"})
public final class LintResourcePersistence {
    @NotNull
    public static final LintResourcePersistence INSTANCE = new LintResourcePersistence();

    private LintResourcePersistence() {
    }

    @NotNull
    public final String serialize(@NotNull LintResourceRepository repository2, @NotNull PathVariables pathVariables, @Nullable File root, boolean sort) {
        PathString source;
        Intrinsics.checkNotNullParameter((Object)((Object)repository2), (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        Map<ResourceType, ListMultimap<String, ResourceItem>> typeToMap = repository2.getTypeToMap$lint_cli();
        if (typeToMap.isEmpty()) {
            return "";
        }
        ResourceNamespace namespace = repository2.getNamespace();
        boolean framework = Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID);
        StringBuilder stringBuilder = new StringBuilder(framework ? 20000000 : 1000);
        SerializationWriter writer = new SerializationWriter(stringBuilder);
        String string = namespace.getXmlNamespaceUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getXmlNamespaceUri(...)");
        writer.write(string);
        writer.write(';');
        String string2 = repository2.getLibraryName();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            writer.write(it);
        }
        writer.write(';');
        HashBiMap hashBiMap = HashBiMap.create((int)(framework ? 11000 : 100));
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        BiMap fileMap = (BiMap)hashBiMap;
        int fileCount = 0;
        for (ListMultimap listMultimap : typeToMap.values()) {
            for (ResourceItem item : listMultimap.values()) {
                source = item.getSource();
                Integer n = (Integer)fileMap.get((Object)source);
                if (n != null) continue;
                LintResourcePersistence $this$serialize_u24lambda_u241 = this;
                boolean bl = false;
                Map map = (Map)fileMap;
                int n2 = fileCount;
                fileCount = n2 + 1;
                Integer n3 = n2;
                map.put(source, n3);
                n = Unit.INSTANCE;
            }
        }
        File file = root;
        String rootPath = file != null ? file.getPath() : null;
        BiMap biMap = fileMap.inverse();
        int n = fileCount;
        for (int i = 0; i < n; ++i) {
            if ((PathString)biMap.get((Object)i) == null) continue;
            writer.writePath(pathVariables, rootPath, source.getRawPath());
            writer.write(',');
        }
        Collection entries = sort ? (Collection)CollectionsKt.sortedWith((Iterable)typeToMap.entrySet(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
            }
        }) : (Collection)typeToMap.entrySet();
        for (Map.Entry entry : entries) {
            Collection collection;
            ResourceType type = (ResourceType)entry.getKey();
            ListMultimap map = (ListMultimap)entry.getValue();
            if (map.isEmpty()) continue;
            writer.write('+');
            String string3 = type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            writer.write(string3);
            writer.write(':');
            if (sort) {
                Collection collection2 = map.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"values(...)");
                collection = CollectionsKt.sortedWith((Iterable)collection2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ResourceItem it = (ResourceItem)a;
                        boolean bl = false;
                        ResourceItem resourceItem = it;
                        it = (ResourceItem)b;
                        Comparable comparable = (Comparable)((Object)(resourceItem != null ? resourceItem.getName() : null));
                        bl = false;
                        ResourceItem resourceItem2 = it;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(resourceItem2 != null ? resourceItem2.getName() : null))));
                    }
                });
            } else {
                collection = map.values();
            }
            Collection values = collection;
            for (ResourceItem item : values) {
                SerializationWriter serializationWriter;
                String string4 = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                writer.escape(string4);
                writer.write(',');
                writer.write(String.valueOf(fileMap.get((Object)item.getSource())));
                writer.write(',');
                if (item.isFileBased()) {
                    serializationWriter = writer.write('F');
                } else {
                    writer.write('V');
                    if (item instanceof LintResourceItem) {
                        SourcePosition sourcePosition = ((LintResourceItem)item).getPosition();
                        if (sourcePosition == null) {
                            sourcePosition = SourcePosition.UNKNOWN;
                        }
                        SourcePosition position = sourcePosition;
                        writer.writeHex(this.encodeLineColumnOffset(position.getStartLine(), position.getStartColumn(), position.getStartOffset()));
                        writer.write(',');
                        writer.writeHex(this.encodeLineColumnOffset(position.getEndLine(), position.getEndColumn(), position.getEndOffset()));
                        writer.write(',');
                        String ignoredIds = ((LintResourceItem)item).getIgnoredIds();
                        if (((CharSequence)ignoredIds).length() > 0) {
                            writer.write(ignoredIds);
                        }
                    } else if (item instanceof Location.LocationAware) {
                        String ignoredIds;
                        if (!LintClient.Companion.isUnitTest()) {
                            throw new IllegalStateException();
                        }
                        Location location = ((Location.LocationAware)item).getLocation();
                        Position start = location.getStart();
                        Position end = location.getEnd();
                        Position position = start;
                        Position position2 = start;
                        Position position3 = start;
                        writer.writeHex(this.encodeLineColumnOffset(position != null ? position.getLine() : -1, position2 != null ? position2.getColumn() : -1, position3 != null ? position3.getOffset() : -1));
                        writer.write(',');
                        Position position4 = end;
                        Position position5 = end;
                        Position position6 = end;
                        writer.writeHex(this.encodeLineColumnOffset(position4 != null ? position4.getLine() : -1, position5 != null ? position5.getColumn() : -1, position6 != null ? position6.getOffset() : -1));
                        writer.write(',');
                        if (item instanceof Issue.IgnoredIdProvider && ((CharSequence)(ignoredIds = ((Issue.IgnoredIdProvider)item).getIgnoredIds())).length() > 0) {
                            writer.write(ignoredIds);
                        }
                    } else {
                        writer.write("-,-,");
                    }
                    serializationWriter = writer.write(';');
                }
                if (item.getResourceValue() != null) {
                    boolean bl = false;
                    if (!item.isFileBased()) {
                        ResourceValue resourceValue;
                        if (item.getType() == ResourceType.ARRAY && resourceValue instanceof ArrayResourceValue) {
                            int n4 = ((ArrayResourceValue)resourceValue).getElementCount();
                            for (int i = 0; i < n4; ++i) {
                                String string5 = ((ArrayResourceValue)resourceValue).getElement(i);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getElement(...)");
                                writer.escape(string5);
                                writer.write(',');
                            }
                        } else if (item.getType() == ResourceType.PLURALS && resourceValue instanceof PluralsResourceValue) {
                            int n5 = ((PluralsResourceValue)resourceValue).getPluralsCount();
                            for (int i = 0; i < n5; ++i) {
                                String string6 = ((PluralsResourceValue)resourceValue).getQuantity(i);
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getQuantity(...)");
                                writer.write(string6);
                                writer.write(':');
                                String string7 = ((PluralsResourceValue)resourceValue).getValue(i);
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
                                writer.escape(string7);
                                writer.write(',');
                            }
                        } else if (item.getType() == ResourceType.STYLE && resourceValue instanceof StyleResourceValue) {
                            String parentStyleName = ((StyleResourceValue)resourceValue).getParentStyleName();
                            SerializationWriter serializationWriter2 = parentStyleName == null ? writer.write("N") : (((CharSequence)parentStyleName).length() == 0 ? writer.write("E") : writer.write("D").escape(parentStyleName).write(','));
                            for (StyleItemResourceValue styleItem : ((StyleResourceValue)resourceValue).getDefinedItems()) {
                                String string8 = styleItem.getAttrName();
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAttrName(...)");
                                writer.escape(string8);
                                writer.write(':');
                                String string9 = styleItem.getValue();
                                if (string9 == null) {
                                    string9 = "";
                                }
                                writer.escape(string9);
                                writer.write(',');
                            }
                        } else if (item.getType() == ResourceType.ATTR && resourceValue instanceof AttrResourceValueImpl) {
                            Set set = ((AttrResourceValueImpl)resourceValue).getFormats();
                            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFormats(...)");
                            if (!((Collection)set).isEmpty()) {
                                Set set2 = ((AttrResourceValueImpl)resourceValue).getFormats();
                                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFormats(...)");
                                writer.write(CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)"|", null, null, (int)0, null, (Function1)serialize.3.1.INSTANCE, (int)30, null));
                            }
                            writer.write(':');
                            Map map2 = ((AttrResourceValueImpl)resourceValue).getAttributeValues();
                            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAttributeValues(...)");
                            for (Map.Entry entry2 : map2.entrySet()) {
                                String key = (String)entry2.getKey();
                                Integer n2 = (Integer)entry2.getValue();
                                Intrinsics.checkNotNull((Object)key);
                                writer.escape(key);
                                writer.write(':');
                                Object object = n2;
                                if (object == null || (object = ((Integer)object).toString()) == null) {
                                    object = "";
                                }
                                writer.escape((String)object);
                                writer.write(',');
                            }
                        } else if (item.getType() == ResourceType.STYLEABLE && resourceValue instanceof StyleableResourceValue) {
                            for (AttrResourceValue attribute : ((StyleableResourceValue)resourceValue).getAllAttributes()) {
                                SerializationWriter serializationWriter3 = writer.write('-');
                                String string10 = attribute.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getName(...)");
                                serializationWriter3.escape(string10).write(':');
                                Set set = attribute.getFormats();
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFormats(...)");
                                if (!((Collection)set).isEmpty()) {
                                    Set set3 = attribute.getFormats();
                                    Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"getFormats(...)");
                                    writer.write(CollectionsKt.joinToString$default((Iterable)set3, (CharSequence)"|", null, null, (int)0, null, (Function1)serialize.3.2.INSTANCE, (int)30, null));
                                }
                                writer.write(':');
                                Map map3 = attribute.getAttributeValues();
                                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getAttributeValues(...)");
                                for (Map.Entry entry2 : map3.entrySet()) {
                                    String key = (String)entry2.getKey();
                                    Integer value2 = (Integer)entry2.getValue();
                                    Intrinsics.checkNotNull((Object)key);
                                    writer.escape(key);
                                    writer.write(':');
                                    Object object = value2;
                                    if (object == null || (object = ((Integer)object).toString()) == null) {
                                        object = "";
                                    }
                                    writer.escape((String)object);
                                    writer.write(',');
                                }
                            }
                        } else if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)type) && resourceValue instanceof DensityBasedResourceValue) {
                            String density = ((DensityBasedResourceValue)resourceValue).getResourceDensity().getResourceValue();
                            Intrinsics.checkNotNull((Object)density);
                            writer.write(density);
                        } else if (resourceValue.getValue() != null) {
                            String rawSource;
                            String it;
                            boolean bl2 = false;
                            writer.write('\"');
                            writer.escape(it);
                            writer.write('\"');
                            ResourceValue resourceValue2 = item.getResourceValue();
                            String string11 = rawSource = resourceValue2 != null ? resourceValue2.getRawXmlValue() : null;
                            if (rawSource != null && !Intrinsics.areEqual((Object)it, (Object)rawSource)) {
                                writer.escape(rawSource);
                            }
                        }
                    }
                }
                writer.write(';');
            }
        }
        String string12 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toString(...)");
        return string12;
    }

    public static /* synthetic */ String serialize$default(LintResourcePersistence lintResourcePersistence, LintResourceRepository lintResourceRepository, PathVariables pathVariables, File file, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return lintResourcePersistence.serialize(lintResourceRepository, pathVariables, file, bl);
    }

    private final long encodeLineColumnOffset(int line2, int column, int offset) {
        return (long)column << 32 | (long)line2 << 16 | (long)offset;
    }

    private final int decodeLine(long bits) {
        return (int)(bits >> 16 & 0xFFFFL);
    }

    private final int decodeColumn(long bits) {
        return (int)(bits >> 32 & 0xFFFFL);
    }

    private final int decodeOffset(long bits) {
        return (int)(bits & 0xFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LintResourceRepository deserialize(@NotNull String s, @NotNull PathVariables pathVariables, @Nullable File root, @Nullable Project project, boolean allowMissingPathVariable) {
        CharSequence charSequence;
        CharSequence charSequence2;
        ResourceNamespace namespace;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        if (((CharSequence)s).length() == 0) {
            return LintResourceRepository.Companion.EmptyRepository.INSTANCE;
        }
        Map map = new EnumMap(ResourceType.class);
        DeserializationReader reader = new DeserializationReader(s);
        String namespaceUri = reader.readString(';');
        ResourceNamespace resourceNamespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
        if (resourceNamespace == null) {
            resourceNamespace = namespace = ResourceNamespace.RES_AUTO;
        }
        if (StringsKt.isBlank((CharSequence)(charSequence2 = (CharSequence)reader.readString(';')))) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String libraryName = (String)charSequence;
        int size = Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID) ? 11000 : 100;
        ArrayList<File> fileList = new ArrayList<File>(size);
        while (true) {
            DeserializationReader this_$iv = reader;
            boolean $i$f$eof = false;
            if (this_$iv.i >= this_$iv.n) break;
            this_$iv = reader;
            boolean $i$f$peek = false;
            if ((this_$iv.i < this_$iv.n ? (int)this_$iv.s.charAt(this_$iv.i) : 0) == 43) break;
            String path = reader.readString(',');
            File file = pathVariables.fromPathString(path, root, allowMissingPathVariable);
            fileList.add(file);
        }
        HashMap parentConfigMap = new HashMap(size / 4);
        HashMap folderConfigMap = new HashMap(size);
        Iterator iterator = fileList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            File file = (File)iterator2.next();
            Object object = file.getParentFile();
            if (object == null || (object = ((File)object).getName()) == null) continue;
            Object folderName = object;
            FolderConfiguration folderConfiguration = (FolderConfiguration)parentConfigMap.get(folderName);
            if (folderConfiguration == null) {
                FolderConfiguration folderConfiguration2;
                if (FolderConfiguration.getConfigForFolder((String)folderName) != null) {
                    FolderConfiguration folderConfiguration3;
                    FolderConfiguration it = folderConfiguration3;
                    boolean bl = false;
                    it.normalizeByAddingImpliedVersionQualifier();
                    ((Map)parentConfigMap).put(folderName, it);
                    folderConfiguration2 = folderConfiguration3;
                } else {
                    folderConfiguration2 = folderConfiguration = null;
                }
                if (folderConfiguration2 == null) continue;
            }
            FolderConfiguration config = folderConfiguration;
            ((Map)folderConfigMap).put(file, config);
        }
        HashMap valueItems = new HashMap();
        ResourceType type = ResourceType.AAPT;
        while (true) {
            Serializable serializable;
            ResourceMergerItem item;
            String string;
            char this_$iv$iv22;
            int n;
            boolean $i$f$advance;
            DeserializationReader this_$iv = reader;
            boolean $i$f$eof = false;
            if (this_$iv.i >= this_$iv.n) break;
            this_$iv = reader;
            boolean $i$f$peek = false;
            if ((this_$iv.i < this_$iv.n ? (int)this_$iv.s.charAt(this_$iv.i) : 0) == 59) {
                this_$iv = reader;
                $i$f$advance = false;
                n = this_$iv.i;
                this_$iv.i = n + 1;
                this_$iv = reader;
                $i$f$eof = false;
                if (this_$iv.i >= this_$iv.n) break;
            }
            this_$iv = reader;
            $i$f$peek = false;
            if ((this_$iv.i < this_$iv.n ? (int)this_$iv.s.charAt(this_$iv.i) : 0) == 43) {
                this_$iv = reader;
                $i$f$advance = false;
                n = this_$iv.i;
                this_$iv.i = n + 1;
                String typeClass = reader.readString(':');
                ResourceType typeString = ResourceType.fromClassName((String)typeClass);
                int n2 = n = typeString != null ? 1 : 0;
                if (_Assertions.ENABLED && n == 0) {
                    boolean $i$a$-assert-LintResourcePersistence$deserialize$22 = false;
                    String $i$a$-assert-LintResourcePersistence$deserialize$22 = typeClass;
                    throw new AssertionError((Object)$i$a$-assert-LintResourcePersistence$deserialize$22);
                }
                Intrinsics.checkNotNull((Object)typeString);
            }
            String name = reader.readString(',');
            String fileNumString = reader.readString(',');
            int fileNum = Integer.parseInt(fileNumString);
            DeserializationReader this_$iv2 = reader;
            boolean $i$f$next = false;
            try {
                DeserializationReader this_$iv$iv22 = this_$iv2;
                boolean $i$f$peek2 = false;
                this_$iv$iv22 = this_$iv$iv22.i < this_$iv$iv22.n ? this_$iv$iv22.s.charAt(this_$iv$iv22.i) : (char)'\u0000';
            }
            finally {
                int n3 = this_$iv2.i;
                this_$iv2.i = n3 + 1;
            }
            boolean fileBased = this_$iv$iv22 == 'F';
            String args = null;
            String rawSource = null;
            long start = -1L;
            long end = -1L;
            String ignore = "";
            if (!fileBased) {
                String startString = reader.readString(',');
                String endString = reader.readString(',');
                try {
                    if (!Intrinsics.areEqual((Object)startString, (Object)"-")) {
                        start = Long.parseLong(startString, CharsKt.checkRadix((int)16));
                    }
                    end = !Intrinsics.areEqual((Object)endString, (Object)"-") ? Long.parseLong(endString, CharsKt.checkRadix((int)16)) : start;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ignore = reader.readString(';');
            }
            DeserializationReader this_$iv3 = reader;
            boolean $i$f$peek3 = false;
            char peek = this_$iv3.i < this_$iv3.n ? this_$iv3.s.charAt(this_$iv3.i) : (char)'\u0000';
            if (peek == '\"') {
                DeserializationReader this_$iv4 = reader;
                boolean $i$f$advance2 = false;
                int n4 = this_$iv4.i;
                this_$iv4.i = n4 + 1;
                String content = reader.readString('\"');
                DeserializationReader this_$iv5 = reader;
                boolean $i$f$peek4 = false;
                if ((this_$iv5.i < this_$iv5.n ? (int)this_$iv5.s.charAt(this_$iv5.i) : 0) != 59) {
                    rawSource = reader.readString(';');
                }
                string = content;
            } else if (peek != ';') {
                args = reader.readRaw(';');
                string = null;
            } else {
                string = null;
            }
            String content = string;
            Object e = fileList.get(fileNum);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            File file = (File)e;
            Object v = folderConfigMap.get(file);
            Intrinsics.checkNotNull(v);
            FolderConfiguration config = (FolderConfiguration)v;
            if (fileBased) {
                Intrinsics.checkNotNull((Object)namespace);
                item = new LintResourceItem(file, name, namespace, type, null, false, libraryName, config, true, ignore, null);
                LintResourceRepository.Companion.recordItem$lint_cli(map, type, name, (ResourceItem)item);
                serializable = (Serializable)new ResourceFile(file, item, config);
                continue;
            }
            Intrinsics.checkNotNull((Object)namespace);
            item = new LintDeserializedResourceItem(file, name, namespace, type, config, false, rawSource, content, args, libraryName, ignore, start, end);
            LintResourceRepository.Companion.recordItem$lint_cli(map, type, name, (ResourceItem)item);
            List list2 = (List)valueItems.get(file);
            if (list2 == null) {
                ArrayList arrayList;
                ArrayList it = arrayList = new ArrayList();
                boolean bl = false;
                ((Map)valueItems).put(file, it);
                list2 = arrayList;
            }
            List list3 = list2;
            serializable = Boolean.valueOf(list3.add(item));
        }
        for (Map.Entry entry : ((Map)valueItems).entrySet()) {
            File file = (File)entry.getKey();
            List items = (List)entry.getValue();
            Object v = folderConfigMap.get(file);
            Intrinsics.checkNotNull(v);
            FolderConfiguration config = (FolderConfiguration)v;
            List itemList = items;
            new ResourceFile(file, itemList, config);
        }
        Intrinsics.checkNotNull((Object)namespace);
        return new LintResourceRepository(project, map, namespace, libraryName);
    }

    public static /* synthetic */ LintResourceRepository deserialize$default(LintResourcePersistence lintResourcePersistence, String string, PathVariables pathVariables, File file, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            project = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return lintResourcePersistence.deserialize(string, pathVariables, file, project, bl);
    }

    @NotNull
    public final String serialize(@NotNull LintResourceRepository repository2, @NotNull PathVariables pathVariables) {
        Intrinsics.checkNotNullParameter((Object)((Object)repository2), (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        return LintResourcePersistence.serialize$default(this, repository2, pathVariables, null, false, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\nH\u0086\bJ\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nJ\t\u0010\u000e\u001a\u00020\nH\u0086\bJ\t\u0010\u000f\u001a\u00020\u0010H\u0086\bJ\t\u0010\u0011\u001a\u00020\u0012H\u0086\bJ\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/LintResourcePersistence$DeserializationReader;", "", "s", "", "<init>", "(Ljava/lang/String;)V", "i", "", "n", "peek", "", "readString", "terminator", "readRaw", "next", "advance", "", "eof", "", "toString", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintResourcePersistence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence$DeserializationReader\n*L\n1#1,832:1\n355#1,4:833\n*S KotlinDebug\n*F\n+ 1 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence$DeserializationReader\n*L\n429#1:833,4\n*E\n"})
    private static final class DeserializationReader {
        @NotNull
        private final String s;
        private int i;
        private final int n;

        public DeserializationReader(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.s = s;
            this.n = this.s.length();
        }

        public final char peek() {
            boolean $i$f$peek = false;
            return this.i < this.n ? this.s.charAt(this.i) : (char)'\u0000';
        }

        @NotNull
        public final String readString(char terminator) {
            char c;
            if (this.s.charAt(this.i) == terminator) {
                int n = this.i;
                this.i = n + 1;
                return "";
            }
            int n = this.n;
            for (int index = this.i; index < n && (c = this.s.charAt(index)) != '\\'; ++index) {
                if (c != terminator) continue;
                String string = this.s.substring(this.i, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string;
                this.i = index + 1;
                return string2;
            }
            StringBuilder contentBuilder = new StringBuilder();
            while (this.i < this.n) {
                char c2;
                char c3 = this.i;
                this.i = c3 + 1;
                char p = this.s.charAt(c3);
                if (p == '\\') {
                    if (this.i >= this.n) break;
                    int n2 = this.i;
                    this.i = n2 + 1;
                    c2 = this.s.charAt(n2);
                } else {
                    c2 = p;
                }
                c3 = c2;
                if (p == terminator) break;
                contentBuilder.append(c3);
            }
            String string = contentBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String readRaw(char terminator) {
            int n;
            char p;
            int begin = this.i;
            while (this.i < this.n && (p = this.s.charAt(this.i)) != terminator) {
                if (p == '\\') {
                    n = this.i;
                    this.i = n + 1;
                }
                n = this.i;
                this.i = n + 1;
            }
            String string = this.s;
            n = this.i;
            this.i = n + 1;
            String string2 = string.substring(begin, n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final char next() {
            boolean $i$f$next = false;
            try {
                DeserializationReader this_$iv = this;
                boolean $i$f$peek = false;
                char c = this_$iv.i < this_$iv.n ? this_$iv.s.charAt(this_$iv.i) : (char)'\u0000';
                return c;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                int n = this.i;
                this.i = n + 1;
                InlineMarker.finallyEnd((int)1);
            }
        }

        public final void advance() {
            boolean $i$f$advance = false;
            int n = this.i;
            this.i = n + 1;
        }

        public final boolean eof() {
            boolean $i$f$eof = false;
            return this.i >= this.n;
        }

        @NotNull
        public String toString() {
            int windowSize = 100;
            int start = Math.max(0, this.i - windowSize);
            int end = Math.min(this.n, this.i + windowSize);
            String string = this.s.substring(start, this.i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = this.s.substring(this.i, end);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + " | " + string2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003Bw\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020\u000fH\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/lint/LintResourcePersistence$LintDeserializedResourceItem;", "Lcom/android/ide/common/resources/ResourceMergerItem;", "Lcom/android/tools/lint/detector/api/Location$LocationAware;", "Lcom/android/tools/lint/detector/api/Issue$IgnoredIdProvider;", "sourceFile", "Ljava/io/File;", "name", "", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "type", "Lcom/android/resources/ResourceType;", "config", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "fileBased", "", "rawSource", "text", "arguments", "library", "ignoredIds", "start", "", "end", "<init>", "(Ljava/io/File;Ljava/lang/String;Lcom/android/ide/common/rendering/api/ResourceNamespace;Lcom/android/resources/ResourceType;Lcom/android/ide/common/resources/configuration/FolderConfiguration;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JJ)V", "getConfiguration", "getFile", "getSource", "Lcom/android/ide/common/util/PathString;", "getValueText", "getResourceValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "getLibraryName", "createResourceValue", "isFileBased", "toString", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "getIgnoredIds", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintResourcePersistence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence$LintDeserializedResourceItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence$DeserializationReader\n*L\n1#1,832:1\n1#2:833\n440#3:834\n440#3:835\n428#3,2:836\n355#3,4:838\n431#3:842\n440#3:843\n428#3,2:844\n355#3,4:846\n431#3:850\n440#3:851\n440#3:852\n355#3,4:853\n436#3,2:857\n440#3:859\n*S KotlinDebug\n*F\n+ 1 LintResourcePersistence.kt\ncom/android/tools/lint/LintResourcePersistence$LintDeserializedResourceItem\n*L\n714#1:834\n722#1:835\n731#1:836,2\n731#1:838,4\n731#1:842\n737#1:843\n747#1:844,2\n747#1:846,4\n747#1:850\n749#1:851\n758#1:852\n759#1:853,4\n760#1:857,2\n782#1:859\n*E\n"})
    private static final class LintDeserializedResourceItem
    extends ResourceMergerItem
    implements Location.LocationAware,
    Issue.IgnoredIdProvider {
        @NotNull
        private final File sourceFile;
        @NotNull
        private final FolderConfiguration config;
        private final boolean fileBased;
        @Nullable
        private final String rawSource;
        @Nullable
        private final String text;
        @Nullable
        private final String arguments;
        @Nullable
        private final String library;
        @NotNull
        private final String ignoredIds;
        private final long start;
        private final long end;

        public LintDeserializedResourceItem(@NotNull File sourceFile, @NotNull String name, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull FolderConfiguration config, boolean fileBased, @Nullable String rawSource, @Nullable String text, @Nullable String arguments, @Nullable String library, @NotNull String ignoredIds, long start, long end) {
            Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)ignoredIds, (String)"ignoredIds");
            super(name, namespace, type, null, Boolean.valueOf(false), null);
            this.sourceFile = sourceFile;
            this.config = config;
            this.fileBased = fileBased;
            this.rawSource = rawSource;
            this.text = text;
            this.arguments = arguments;
            this.library = library;
            this.ignoredIds = ignoredIds;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public FolderConfiguration getConfiguration() {
            return this.config;
        }

        @NotNull
        public File getFile() {
            return this.sourceFile;
        }

        @NotNull
        public PathString getSource() {
            return new PathString(this.sourceFile);
        }

        @NotNull
        public String getValueText() {
            String string = this.text;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public ResourceValue getResourceValue() {
            ResourceValue resourceValue = this.mResourceValue;
            if (resourceValue == null) {
                ResourceValue resourceValue2;
                ResourceValue it = resourceValue2 = this.createResourceValue();
                boolean bl = false;
                this.mResourceValue = it;
                resourceValue = resourceValue2;
            }
            return resourceValue;
        }

        @Nullable
        public String getLibraryName() {
            return this.library;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ResourceValue createResourceValue() {
            ResourceValue resourceValue;
            if (this.arguments == null) {
                resourceValue = (ResourceValue)(this.getType() == ResourceType.ATTR ? (ResourceValueImpl)new AttrResourceValueImpl(this.getNamespace(), this.getName(), this.library) : (this.getType() == ResourceType.STRING && this.text != null ? (ResourceValueImpl)new TextResourceValueImpl(this.getNamespace(), this.getName(), this.text, this.rawSource, this.library) : (this.getType() == ResourceType.ARRAY ? (ResourceValueImpl)new ArrayResourceValueImpl(this.getNamespace(), this.getName(), this.library) : (this.getType() == ResourceType.STYLEABLE ? (ResourceValueImpl)new StyleableResourceValueImpl(this.getNamespace(), this.getName(), null, this.library) : (this.getType() == ResourceType.STYLE ? (ResourceValueImpl)new StyleItemResourceValueImpl(this.getNamespace(), this.getName(), null, this.library) : (this.text != null ? new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.text, this.library) : (this.isFileBased() ? new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.sourceFile.getPath(), this.library) : new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.library))))))));
            } else {
                ResourceValueImpl resourceValueImpl;
                boolean bl;
                boolean bl2 = bl = ((CharSequence)this.arguments).length() > 0;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                DeserializationReader reader = new DeserializationReader(this.arguments);
                if (this.getType() == ResourceType.ARRAY) {
                    ArrayResourceValueImpl array = new ArrayResourceValueImpl(this.getNamespace(), this.getName(), this.library);
                    while (true) {
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String element = reader.readString(',');
                        array.addElement(element);
                    }
                    resourceValueImpl = (ResourceValueImpl)array;
                } else if (this.getType() == ResourceType.PLURALS) {
                    PluralsResourceValueImpl plural = new PluralsResourceValueImpl(this.getNamespace(), this.getName(), this.text, this.library);
                    while (true) {
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String quantity = reader.readString(':');
                        String value = reader.readString(',');
                        plural.addPlural(quantity, value);
                    }
                    resourceValueImpl = (ResourceValueImpl)plural;
                } else if (this.getType() == ResourceType.STYLE) {
                    String string;
                    char this_$iv$iv22;
                    int $i$f$peek;
                    DeserializationReader this_$iv = reader;
                    boolean $i$f$next = false;
                    try {
                        DeserializationReader this_$iv$iv22 = this_$iv;
                        $i$f$peek = 0;
                        this_$iv$iv22 = this_$iv$iv22.i < this_$iv$iv22.n ? this_$iv$iv22.s.charAt(this_$iv$iv22.i) : (char)'\u0000';
                    }
                    finally {
                        $i$f$peek = this_$iv.i;
                        this_$iv.i = $i$f$peek + 1;
                    }
                    switch (this_$iv$iv22) {
                        case 'E': {
                            string = "";
                            break;
                        }
                        case 'N': {
                            string = null;
                            break;
                        }
                        default: {
                            string = reader.readString(',');
                        }
                    }
                    String parent = string;
                    StyleResourceValueImpl style = new StyleResourceValueImpl(this.getNamespace(), this.getName(), parent, this.library);
                    while (true) {
                        this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String name = reader.readString(':');
                        String value = reader.readString(',');
                        StyleItemResourceValueImpl item = new StyleItemResourceValueImpl(this.getNamespace(), name, value, this.library);
                        style.addItem((StyleItemResourceValue)item);
                    }
                    resourceValueImpl = (ResourceValueImpl)style;
                } else if (this.getType() == ResourceType.STYLEABLE) {
                    char this_$iv$iv32;
                    int $i$f$peek;
                    StyleableResourceValueImpl style = new StyleableResourceValueImpl(this.getNamespace(), this.getName(), null, this.library);
                    DeserializationReader this_$iv = reader;
                    boolean $i$f$next2 = false;
                    try {
                        DeserializationReader this_$iv$iv32 = this_$iv;
                        $i$f$peek = 0;
                        this_$iv$iv32 = this_$iv$iv32.i < this_$iv$iv32.n ? this_$iv$iv32.s.charAt(this_$iv$iv32.i) : (char)'\u0000';
                    }
                    finally {
                        $i$f$peek = this_$iv.i;
                        this_$iv.i = $i$f$peek + 1;
                    }
                    char separator = this_$iv$iv32;
                    boolean bl3 = this_$iv = separator == '-';
                    if (_Assertions.ENABLED && !this_$iv) {
                        String $i$f$next2 = "Assertion failed";
                        throw new AssertionError((Object)$i$f$next2);
                    }
                    block13: while (true) {
                        this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String attrName = reader.readString(':');
                        AttrResourceValueImpl attr = new AttrResourceValueImpl(this.getNamespace(), attrName, this.library);
                        style.addValue((AttrResourceValue)attr);
                        String format = reader.readString(':');
                        if (((CharSequence)format).length() > 0) {
                            Set formats = AttributeFormat.parse((String)format);
                            attr.setFormats((Collection)formats);
                        }
                        while (true) {
                            DeserializationReader this_$iv2 = reader;
                            boolean $i$f$eof2 = false;
                            if (this_$iv2.i >= this_$iv2.n) continue block13;
                            this_$iv2 = reader;
                            boolean $i$f$peek2 = false;
                            if ((this_$iv2.i < this_$iv2.n ? (int)this_$iv2.s.charAt(this_$iv2.i) : 0) == 45) {
                                this_$iv2 = reader;
                                boolean $i$f$advance = false;
                                int n = this_$iv2.i;
                                this_$iv2.i = n + 1;
                                continue block13;
                            }
                            String name = reader.readString(':');
                            String value = reader.readString(',');
                            attr.addValue(name, !StringsKt.isBlank((CharSequence)value) ? Integer.valueOf(Integer.parseInt(value)) : null, null);
                        }
                        break;
                    }
                    resourceValueImpl = (ResourceValueImpl)style;
                } else if (this.getType() == ResourceType.ATTR) {
                    Collection formats;
                    AttrResourceValueImpl attr = new AttrResourceValueImpl(this.getNamespace(), this.getName(), this.library);
                    String format = reader.readString(':');
                    if (((CharSequence)format).length() == 0) {
                        formats = CollectionsKt.listOf((Object)AttributeFormat.REFERENCE);
                        attr.setFormats(formats);
                    } else {
                        formats = AttributeFormat.parse((String)format);
                        attr.setFormats(formats);
                    }
                    while (true) {
                        DeserializationReader this_$iv = reader;
                        boolean $i$f$eof = false;
                        if (this_$iv.i >= this_$iv.n) break;
                        String name = reader.readString(':');
                        String value = reader.readString(',');
                        attr.addValue(name, !StringsKt.isBlank((CharSequence)value) ? Integer.valueOf(Integer.parseInt(value)) : null, null);
                    }
                    resourceValueImpl = (ResourceValueImpl)attr;
                } else if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)this.getType())) {
                    Density density = Density.getEnum((String)this.arguments);
                    Intrinsics.checkNotNull((Object)density);
                    Density density2 = density;
                    resourceValueImpl = (ResourceValueImpl)new DensityBasedResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), null, density2, this.library);
                } else {
                    resourceValueImpl = new ResourceValueImpl(this.getNamespace(), this.getType(), this.getName(), this.getFile().getPath(), this.library);
                }
                resourceValue = (ResourceValue)resourceValueImpl;
            }
            return resourceValue;
        }

        public boolean isFileBased() {
            return this.fileBased;
        }

        @NotNull
        public String toString() {
            Object object;
            String parentPath;
            String path = this.getFile().getPath();
            File file = this.getFile().getParentFile();
            String string = file != null && (file = file.getParentFile()) != null ? file.getPath() : (parentPath = null);
            if (parentPath != null) {
                String string2 = ((Object)((Object)this)).getClass().getSimpleName();
                Intrinsics.checkNotNull((Object)path);
                String string3 = path.substring(parentPath.length() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                object = string2 + "(" + string3 + ")";
            } else {
                String string4 = super.toString();
                Intrinsics.checkNotNull((Object)string4);
                object = string4;
            }
            return object;
        }

        @NotNull
        public Location getLocation() {
            if (this.start != -1L && this.end != -1L) {
                return Location.Companion.create(this.getFile(), (Position)new DefaultPosition(INSTANCE.decodeLine(this.start), INSTANCE.decodeColumn(this.start), INSTANCE.decodeOffset(this.start)), (Position)new DefaultPosition(INSTANCE.decodeLine(this.end), INSTANCE.decodeColumn(this.end), INSTANCE.decodeOffset(this.end)));
            }
            return Location.Companion.create(this.getFile());
        }

        @NotNull
        public String getIgnoredIds() {
            return this.ignoredIds;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ\b\u0010\u0017\u001a\u00020\u000bH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/LintResourcePersistence$SerializationWriter;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "write", "char", "", "string", "", "writeHex", "long", "", "escape", "s", "writePath", "", "pathVariables", "Lcom/android/tools/lint/model/PathVariables;", "rootPath", "path", "toString", "lint-cli"})
    private static final class SerializationWriter {
        @NotNull
        private final StringBuilder sb;

        public SerializationWriter(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            this.sb = sb;
        }

        @NotNull
        public final SerializationWriter write(char c) {
            this.sb.append(c);
            return this;
        }

        @NotNull
        public final SerializationWriter write(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.sb.append(string);
            return this;
        }

        @NotNull
        public final SerializationWriter writeHex(long l) {
            String string = Long.toString(l, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.sb.append(string);
            return this;
        }

        @NotNull
        public final SerializationWriter escape(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int n = s.length();
            block3: for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ':': 
                    case ';': 
                    case '\\': {
                        SerializationWriter serializationWriter = this.write('\\').write(c);
                        continue block3;
                    }
                    default: {
                        SerializationWriter serializationWriter = this.write(c);
                    }
                }
            }
            return this;
        }

        public final void writePath(@NotNull PathVariables pathVariables, @Nullable String rootPath, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.escape(pathVariables.toPathString(path, rootPath, true));
        }

        @NotNull
        public String toString() {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

