/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.impl.cache.ExplicitTypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.TypeReference;

public final class SignatureParsing {
    private static final char VARIANCE_NONE = '\u0000';
    private static final char VARIANCE_EXTENDS = '+';
    private static final char VARIANCE_SUPER = '-';

    private SignatureParsing() {
    }

    @NotNull
    static TypeParametersDeclaration parseTypeParametersDeclaration(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        if (signature.current() != '<') {
            TypeParametersDeclaration typeParametersDeclaration = TypeParametersDeclaration.EMPTY;
            if (typeParametersDeclaration == null) {
                SignatureParsing.$$$reportNull$$$0(0);
            }
            return typeParametersDeclaration;
        }
        ArrayList<TypeParameterDeclaration> typeParameters = new ArrayList<TypeParameterDeclaration>();
        signature.next();
        while (signature.current() != '>') {
            typeParameters.add(SignatureParsing.parseTypeParameter(signature, mapping));
        }
        signature.next();
        return new TypeParametersDeclaration(typeParameters);
    }

    private static TypeParameterDeclaration parseTypeParameter(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        int from = signature.pos();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            signature.next();
        }
        String name = signature.substring(from);
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping.toTypeInfo(name).text();
        SmartList<TypeInfo> bounds = new SmartList<TypeInfo>();
        while (signature.current() == ':') {
            signature.next();
            TypeInfo bound = SignatureParsing.parseTopLevelClassRefSignatureToTypeInfo(signature, mapping);
            if (!bounds.isEmpty() && bound == null) continue;
            bounds.add(bound);
        }
        return new TypeParameterDeclaration(parameterName, bounds.toArray(TypeInfo.EMPTY_ARRAY));
    }

    @Nullable
    static TypeInfo parseTopLevelClassRefSignatureToTypeInfo(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature, mapping);
            }
            case 'T': {
                return new TypeInfo.RefTypeInfo(SignatureParsing.parseTypeVariableRefSignature(signature));
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharIterator signature) throws ClsFormatException {
        signature.next();
        int from = signature.pos();
        while (signature.current() != ';' && signature.current() != '>' && signature.current() != '\uffff') {
            signature.next();
        }
        String id = signature.substring(from);
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id;
    }

    @NotNull
    private static TypeInfo parseParameterizedClassRefSignatureToTypeInfo(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        signature.next();
        int start = signature.pos();
        boolean hasSpace = false;
        while (true) {
            switch (signature.current()) {
                case ';': {
                    String jvmName = signature.substring(start);
                    if (hasSpace) {
                        jvmName = jvmName.replace(" ", "");
                    }
                    TypeInfo.RefTypeInfo type = mapping.toTypeInfo(jvmName);
                    signature.next();
                    TypeInfo.RefTypeInfo refTypeInfo = type;
                    if (refTypeInfo == null) {
                        SignatureParsing.$$$reportNull$$$0(1);
                    }
                    return refTypeInfo;
                }
                case '\uffff': {
                    throw new ClsFormatException("Malformed signature: " + signature);
                }
                case '<': {
                    String jvmName = signature.substring(start);
                    if (hasSpace) {
                        jvmName = jvmName.replace(" ", "");
                    }
                    TypeInfo.RefTypeInfo type = mapping.toTypeInfo(jvmName);
                    signature.next();
                    ArrayList<TypeInfo> components2 = new ArrayList<TypeInfo>();
                    do {
                        components2.add(SignatureParsing.parseClassOrTypeVariableElementToTypeInfo(signature, mapping));
                    } while (signature.current() != '>');
                    type = type.withComponents(components2);
                    signature.next();
                    switch (signature.current()) {
                        case ';': {
                            signature.next();
                            TypeInfo.RefTypeInfo refTypeInfo = type;
                            if (refTypeInfo == null) {
                                SignatureParsing.$$$reportNull$$$0(2);
                            }
                            return refTypeInfo;
                        }
                        case '.': {
                            TypeInfo inner = SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature, mapping);
                            if (!(inner instanceof TypeInfo.RefTypeInfo)) {
                                throw new ClsFormatException("Malformed signature: " + signature);
                            }
                            TypeInfo.RefTypeInfo refTypeInfo = ((TypeInfo.RefTypeInfo)inner).withOuter(type);
                            if (refTypeInfo == null) {
                                SignatureParsing.$$$reportNull$$$0(3);
                            }
                            return refTypeInfo;
                        }
                    }
                    throw new ClsFormatException("Malformed signature: " + signature);
                }
                case ' ': {
                    hasSpace = true;
                    break;
                }
            }
            signature.next();
        }
    }

    @NotNull
    private static TypeInfo parseClassOrTypeVariableElementToTypeInfo(@NotNull CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        char variance;
        if (signature == null) {
            SignatureParsing.$$$reportNull$$$0(4);
        }
        if ((variance = SignatureParsing.parseVariance(signature)) == '*') {
            return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.WILDCARD);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        TypeInfo info = SignatureParsing.parseTypeWithoutVarianceToTypeInfo(signature, mapping);
        if (info == null) {
            throw new ClsFormatException("Unable to parse signature: " + signature);
        }
        while (dimensions > 0) {
            --dimensions;
            info = info.arrayOf();
        }
        switch (variance) {
            case '\u0000': {
                TypeInfo typeInfo = info;
                if (typeInfo == null) {
                    SignatureParsing.$$$reportNull$$$0(5);
                }
                return typeInfo;
            }
            case '+': {
                return new TypeInfo.DerivedTypeInfo(TypeInfo.TypeKind.EXTENDS, info);
            }
            case '-': {
                return new TypeInfo.DerivedTypeInfo(TypeInfo.TypeKind.SUPER, info);
            }
        }
        throw new ClsFormatException("Unable to parse signature: " + signature);
    }

    private static char parseVariance(CharIterator signature) {
        char variance;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    private static int parseDimensions(CharIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @Deprecated
    @NotNull
    public static String parseTypeString(CharacterIterator signature, Function<? super String, String> mapping) throws ClsFormatException {
        char ch;
        StringBuilder sb = new StringBuilder();
        int pos = signature.getIndex();
        while ((ch = signature.current()) != '\uffff') {
            sb.append(ch);
            signature.next();
        }
        CharIterator iterator2 = new CharIterator(sb.toString());
        String result2 = SignatureParsing.parseTypeStringToTypeInfo(iterator2, TypeInfoProvider.from(mapping)).text();
        signature.setIndex(iterator2.pos() + pos);
        String string = result2;
        if (string == null) {
            SignatureParsing.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static TypeInfo parseTypeStringToTypeInfo(@NotNull CharIterator signature, @NotNull TypeInfoProvider mapping) throws ClsFormatException {
        if (signature == null) {
            SignatureParsing.$$$reportNull$$$0(7);
        }
        if (mapping == null) {
            SignatureParsing.$$$reportNull$$$0(8);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        TypeInfo type = SignatureParsing.parseTypeWithoutVarianceToTypeInfo(signature, mapping);
        if (type == null) {
            throw new ClsFormatException();
        }
        while (dimensions > 0) {
            --dimensions;
            type = type.arrayOf();
        }
        TypeInfo typeInfo = type;
        if (typeInfo == null) {
            SignatureParsing.$$$reportNull$$$0(9);
        }
        return typeInfo;
    }

    @Nullable
    private static TypeInfo parseTypeWithoutVarianceToTypeInfo(CharIterator signature, TypeInfoProvider mapping) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature, mapping);
            }
            case 'T': {
                return new TypeInfo.RefTypeInfo(SignatureParsing.parseTypeVariableRefSignature(signature));
            }
            case 'B': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.BYTE);
            }
            case 'C': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.CHAR);
            }
            case 'D': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.DOUBLE);
            }
            case 'F': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.FLOAT);
            }
            case 'I': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.INT);
            }
            case 'J': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.LONG);
            }
            case 'S': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.SHORT);
            }
            case 'Z': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.BOOLEAN);
            }
            case 'V': {
                signature.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.VOID);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/SignatureParsing";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParametersDeclaration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseParameterizedClassRefSignatureToTypeInfo";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/SignatureParsing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassOrTypeVariableElementToTypeInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeStringToTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseClassOrTypeVariableElementToTypeInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeStringToTypeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CharIterator {
        static final int DONE = 65535;
        private final String myData;
        private final int myEnd;
        private int myPos = 0;

        public CharIterator(String data) {
            this.myData = data;
            this.myEnd = data.length();
        }

        char current() {
            if (this.myPos == this.myEnd) {
                return '\uffff';
            }
            return this.myData.charAt(this.myPos);
        }

        void next() {
            if (this.myPos < this.myEnd) {
                ++this.myPos;
            }
        }

        int pos() {
            return this.myPos;
        }

        String substring(int fromIndex) {
            return this.myData.substring(fromIndex, this.myPos);
        }

        public String toString() {
            return this.myData;
        }
    }

    static class TypeParametersDeclaration {
        static final TypeParametersDeclaration EMPTY = new TypeParametersDeclaration(Collections.emptyList());
        private final List<TypeParameterDeclaration> myDeclarations;

        private TypeParametersDeclaration(List<TypeParameterDeclaration> declarations) {
            this.myDeclarations = declarations;
        }

        TypeInfo getBoundType(TypeReference ref) {
            TypeParameterDeclaration typeParam;
            int typeParameterIndex = ref.getTypeParameterIndex();
            int boundIndex = ref.getTypeParameterBoundIndex();
            if (typeParameterIndex < this.myDeclarations.size() && boundIndex < (typeParam = this.myDeclarations.get(typeParameterIndex)).myBounds.length) {
                return typeParam.myBounds[boundIndex];
            }
            return null;
        }

        TypeInfo getParameterType(TypeReference ref) {
            int typeParameterIndex = ref.getTypeParameterIndex();
            if (typeParameterIndex < this.myDeclarations.size()) {
                return this.myDeclarations.get(typeParameterIndex).myTypeParameter;
            }
            return null;
        }

        void fillInTypeParameterList(StubElement<?> parent) {
            List<TypeParameterDeclaration> declarations = this.myDeclarations;
            if (declarations.isEmpty()) {
                return;
            }
            PsiTypeParameterListStub listStub = parent.findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
            if (listStub == null) {
                return;
            }
            for (TypeParameterDeclaration parameter : declarations) {
                parameter.createTypeParameter(listStub);
            }
        }
    }

    @FunctionalInterface
    public static interface TypeInfoProvider {
        @NotNull
        public TypeInfo.RefTypeInfo toTypeInfo(@NotNull String var1);

        default public boolean isKnownStatic(@NotNull String jvmClassName) {
            if (jvmClassName == null) {
                TypeInfoProvider.$$$reportNull$$$0(0);
            }
            return false;
        }

        public static TypeInfoProvider from(Function<? super String, String> fn) {
            return internalName -> new TypeInfo.RefTypeInfo((String)fn.apply(internalName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmClassName", "com/intellij/psi/impl/compiled/SignatureParsing$TypeInfoProvider", "isKnownStatic"));
        }
    }

    private static class TypeParameterDeclaration {
        private final TypeInfo myTypeParameter;
        private final TypeInfo[] myBounds;

        private TypeParameterDeclaration(String parameter, TypeInfo[] bounds) {
            this.myTypeParameter = new TypeInfo.RefTypeInfo(parameter);
            this.myBounds = bounds;
        }

        private void createTypeParameter(PsiTypeParameterListStub listStub) {
            TypeInfo[] info;
            PsiTypeParameterStubImpl stub = new PsiTypeParameterStubImpl((StubElement)listStub, this.myTypeParameter.text());
            TypeAnnotationContainer annotations = this.myTypeParameter.getTypeAnnotations();
            if (annotations instanceof ExplicitTypeAnnotationContainer) {
                ((ExplicitTypeAnnotationContainer)annotations).createAnnotationStubs(stub);
            }
            if ((info = this.myBounds).length > 0 && info[0] == null) {
                info = Arrays.copyOfRange(info, 1, info.length);
            }
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)stub, info);
        }
    }
}

