/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmEnumField;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationArrayValue;
import com.intellij.psi.PsiAnnotationClassValue;
import com.intellij.psi.PsiAnnotationConstantValue;
import com.intellij.psi.PsiAnnotationEnumFieldValue;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNestedAnnotationValue;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiJvmConversionHelper {
    private static final Logger LOG = Logger.getInstance(PsiJvmConversionHelper.class);
    public static final Map<JvmModifier, String> MODIFIERS;

    static PsiAnnotation @NotNull [] getListAnnotations(@NotNull PsiModifierListOwner modifierListOwner) {
        PsiModifierList list;
        if (modifierListOwner == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(0);
        }
        PsiAnnotation[] psiAnnotationArray = (list = modifierListOwner.getModifierList()) == null ? PsiAnnotation.EMPTY_ARRAY : list.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(1);
        }
        return psiAnnotationArray;
    }

    @Nullable
    static PsiAnnotation getListAnnotation(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String fqn) {
        PsiModifierList list;
        if (modifierListOwner == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(3);
        }
        return (list = modifierListOwner.getModifierList()) == null ? null : list.findAnnotation(fqn);
    }

    static boolean hasListAnnotation(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String fqn) {
        PsiModifierList list;
        if (modifierListOwner == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(5);
        }
        return (list = modifierListOwner.getModifierList()) != null && list.hasAnnotation(fqn);
    }

    static boolean hasListModifier(@NotNull PsiModifierListOwner modifierListOwner, @NotNull JvmModifier modifier) {
        if (modifierListOwner == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(6);
        }
        if (modifier == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(7);
        }
        return modifierListOwner.hasModifierProperty(MODIFIERS.get((Object)modifier));
    }

    @NotNull
    static JvmClassKind getJvmClassKind(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(8);
        }
        if (psiClass.isAnnotationType()) {
            JvmClassKind jvmClassKind = JvmClassKind.ANNOTATION;
            if (jvmClassKind == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(9);
            }
            return jvmClassKind;
        }
        if (psiClass.isInterface()) {
            JvmClassKind jvmClassKind = JvmClassKind.INTERFACE;
            if (jvmClassKind == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(10);
            }
            return jvmClassKind;
        }
        if (psiClass.isEnum()) {
            JvmClassKind jvmClassKind = JvmClassKind.ENUM;
            if (jvmClassKind == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(11);
            }
            return jvmClassKind;
        }
        JvmClassKind jvmClassKind = JvmClassKind.CLASS;
        if (jvmClassKind == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(12);
        }
        return jvmClassKind;
    }

    @Nullable
    static JvmReferenceType getClassSuperType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(13);
        }
        if (psiClass.isInterface()) {
            return null;
        }
        if (psiClass.isEnum()) {
            return PsiType.getTypeByName("java.lang.Enum", psiClass.getProject(), psiClass.getResolveScope());
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                return baseClassType;
            }
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        if (extendsTypes.length != 1) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        return extendsTypes[0];
    }

    static JvmReferenceType @NotNull [] getClassInterfaces(@NotNull PsiClass psiClass) {
        PsiReferenceList referenceList;
        if (psiClass == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(14);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                JvmReferenceType[] jvmReferenceTypeArray = new JvmReferenceType[]{baseClassType};
                if (jvmReferenceTypeArray == null) {
                    PsiJvmConversionHelper.$$$reportNull$$$0(15);
                }
                return jvmReferenceTypeArray;
            }
            if (JvmReferenceType.EMPTY_ARRAY == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(16);
            }
            return JvmReferenceType.EMPTY_ARRAY;
        }
        PsiReferenceList psiReferenceList = referenceList = psiClass.isInterface() ? psiClass.getExtendsList() : psiClass.getImplementsList();
        if (referenceList == null) {
            if (JvmReferenceType.EMPTY_ARRAY == null) {
                PsiJvmConversionHelper.$$$reportNull$$$0(17);
            }
            return JvmReferenceType.EMPTY_ARRAY;
        }
        JvmReferenceType[] jvmReferenceTypeArray = referenceList.getReferencedTypes();
        if (jvmReferenceTypeArray == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(18);
        }
        return jvmReferenceTypeArray;
    }

    @NotNull
    static String getAnnotationAttributeName(@NotNull PsiNameValuePair pair) {
        String name;
        if (pair == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(19);
        }
        String string = (name = pair.getName()) == null ? "value" : name;
        if (string == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    static JvmAnnotationAttributeValue getAnnotationAttributeValue(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            PsiJvmConversionHelper.$$$reportNull$$$0(21);
        }
        return PsiJvmConversionHelper.getAnnotationAttributeValue(pair.getValue());
    }

    @Nullable
    static JvmAnnotationAttributeValue getAnnotationAttributeValue(@Nullable PsiAnnotationMemberValue value) {
        PsiElement resolved;
        if (value instanceof PsiClassObjectAccessExpression) {
            return new PsiAnnotationClassValue((PsiClassObjectAccessExpression)value);
        }
        if (value instanceof PsiAnnotation) {
            return new PsiNestedAnnotationValue((PsiAnnotation)value);
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            return new PsiAnnotationArrayValue((PsiArrayInitializerMemberValue)value);
        }
        if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof JvmEnumField) {
            return new PsiAnnotationEnumFieldValue((PsiReferenceExpression)value, (JvmEnumField)((Object)resolved));
        }
        if (value instanceof PsiExpression) {
            return new PsiAnnotationConstantValue((PsiExpression)value);
        }
        if (value != null) {
            LOG.warn(new RuntimeExceptionWithAttachments("Not implemented: " + value.getClass(), new Attachment("text", value.getText())));
        }
        return null;
    }

    static {
        EnumMap<JvmModifier, String> modifiers = new EnumMap<JvmModifier, String>(JvmModifier.class);
        modifiers.put(JvmModifier.PUBLIC, "public");
        modifiers.put(JvmModifier.PROTECTED, "protected");
        modifiers.put(JvmModifier.PRIVATE, "private");
        modifiers.put(JvmModifier.PACKAGE_LOCAL, "packageLocal");
        modifiers.put(JvmModifier.STATIC, "static");
        modifiers.put(JvmModifier.ABSTRACT, "abstract");
        modifiers.put(JvmModifier.FINAL, "final");
        modifiers.put(JvmModifier.NATIVE, "native");
        modifiers.put(JvmModifier.SYNCHRONIZED, "synchronized");
        modifiers.put(JvmModifier.STRICTFP, "strictfp");
        modifiers.put(JvmModifier.TRANSIENT, "transient");
        modifiers.put(JvmModifier.VOLATILE, "volatile");
        modifiers.put(JvmModifier.TRANSITIVE, "transitive");
        MODIFIERS = Collections.unmodifiableMap(modifiers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiJvmConversionHelper";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiJvmConversionHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListAnnotations";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmClassKind";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInterfaces";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getListAnnotations";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getListAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasListAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasListModifier";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJvmClassKind";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClassSuperType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getClassInterfaces";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttributeName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttributeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

