/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicLiteralUtil {
    private BasicLiteralUtil() {
    }

    @Nullable
    public static String getTextBlockIndentString(@NotNull PsiElement expression) {
        String[] lines;
        if (expression == null) {
            BasicLiteralUtil.$$$reportNull$$$0(0);
        }
        if ((lines = BasicLiteralUtil.getTextBlockLines(expression.getText(), true)) == null) {
            return null;
        }
        return BasicLiteralUtil.getTextBlockIndentString(lines);
    }

    public static int getTextBlockIndent(@NotNull PsiElement expression) {
        String[] lines;
        if (expression == null) {
            BasicLiteralUtil.$$$reportNull$$$0(1);
        }
        if ((lines = BasicLiteralUtil.getTextBlockLines(expression.getText(), true)) == null) {
            return -1;
        }
        return BasicLiteralUtil.getTextBlockIndent(lines);
    }

    public static String @Nullable [] getTextBlockLines(@NotNull PsiElement expression) {
        if (expression == null) {
            BasicLiteralUtil.$$$reportNull$$$0(2);
        }
        String rawText = expression.getText();
        return BasicLiteralUtil.getTextBlockLines(rawText);
    }

    public static String @Nullable [] getTextBlockLines(String rawText) {
        return BasicLiteralUtil.getTextBlockLines(rawText, false);
    }

    private static String @Nullable [] getTextBlockLines(String rawText, boolean skipFirstLine) {
        char c;
        if (rawText.length() < 7 || !rawText.startsWith("\"\"\"") || !rawText.endsWith("\"\"\"")) {
            return null;
        }
        int start = 3;
        while ((c = rawText.charAt(start++)) != '\n') {
            if ((skipFirstLine || BasicLiteralUtil.isTextBlockWhiteSpace(c)) && start != rawText.length()) continue;
            return null;
        }
        return rawText.substring(start, rawText.length() - 3).split("\n", -1);
    }

    public static boolean isTextBlockWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\f';
    }

    public static int getTextBlockIndent(String @NotNull [] lines) {
        if (lines == null) {
            BasicLiteralUtil.$$$reportNull$$$0(3);
        }
        return BasicLiteralUtil.getTextBlockIndent(lines, false, false);
    }

    public static int getTextBlockIndent(String @NotNull [] lines, boolean preserveContent, boolean ignoreLastLine) {
        if (lines == null) {
            BasicLiteralUtil.$$$reportNull$$$0(4);
        }
        return BasicLiteralUtil.getTextBlockIndentInner(lines, preserveContent, ignoreLastLine).indentSize;
    }

    @NotNull
    private static IndentResult getTextBlockIndentInner(String @NotNull [] lines, boolean preserveContent, boolean ignoreLastLine) {
        if (lines == null) {
            BasicLiteralUtil.$$$reportNull$$$0(5);
        }
        int prefix = Integer.MAX_VALUE;
        int position = -1;
        for (int i = 0; i < lines.length && prefix != 0; ++i) {
            int indent;
            String line = lines[i];
            for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
            }
            if (indent == line.length() && (i < lines.length - 1 || ignoreLastLine)) {
                if (!preserveContent) {
                    lines[i] = "";
                }
                if (lines.length != 1) continue;
                prefix = indent;
                position = i;
                continue;
            }
            if (indent >= prefix) continue;
            prefix = indent;
            position = i;
        }
        return new IndentResult(prefix, position);
    }

    @NotNull
    private static String getTextBlockIndentString(String @NotNull [] lines) {
        if (lines == null) {
            BasicLiteralUtil.$$$reportNull$$$0(6);
        }
        IndentResult result2 = BasicLiteralUtil.getTextBlockIndentInner(lines, true, false);
        String restorationLine = lines[result2.indentLineNumber];
        String string = restorationLine.substring(0, result2.indentSize);
        if (string == null) {
            BasicLiteralUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/BasicLiteralUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/BasicLiteralUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextBlockIndentString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockIndentString";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockIndent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockIndentInner";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndentResult {
        private final int indentSize;
        private final int indentLineNumber;

        private IndentResult(int indentSize, int indentLineNumber) {
            this.indentSize = indentSize;
            this.indentLineNumber = indentLineNumber;
        }
    }
}

