/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.indices;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.containers.BidirectionalLongSetMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB)\b\u0002\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ#\u0010\u000f\u001a\u000e\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u0004\u0018\u00018\u00002\n\u0010\u0017\u001a\u00060\u0011j\u0002`\u0012H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0000\u00a2\u0006\u0002\b\u001cR$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0004j\b\u0012\u0004\u0012\u00028\u0000`\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "T", "", "index", "Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageIndex;", "oneToOneAssociation", "", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;Z)V", "(Z)V", "getIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;", "getOneToOneAssociation", "()Z", "getIdsByEntry", "", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "entry", "getIdsByEntry$intellij_platform_workspace_storage", "(Ljava/lang/Object;)Ljava/util/List;", "getEntryById", "id", "getEntryById$intellij_platform_workspace_storage", "(J)Ljava/lang/Object;", "entries", "", "entries$intellij_platform_workspace_storage", "MutableEntityStorageInternalIndex", "intellij.platform.workspace.storage"})
public class EntityStorageInternalIndex<T> {
    @NotNull
    private final BidirectionalLongSetMap<T> index;
    private final boolean oneToOneAssociation;

    private EntityStorageInternalIndex(BidirectionalLongSetMap<T> index, boolean oneToOneAssociation) {
        this.index = index;
        this.oneToOneAssociation = oneToOneAssociation;
    }

    @NotNull
    public BidirectionalLongSetMap<T> getIndex$intellij_platform_workspace_storage() {
        return this.index;
    }

    protected final boolean getOneToOneAssociation() {
        return this.oneToOneAssociation;
    }

    public EntityStorageInternalIndex(boolean oneToOneAssociation) {
        this(new BidirectionalLongSetMap(), oneToOneAssociation);
    }

    @Nullable
    public final List<Long> getIdsByEntry$intellij_platform_workspace_storage(T entry) {
        LongSet longSet = this.getIndex$intellij_platform_workspace_storage().getKeysByValue(entry);
        return longSet != null ? CollectionsKt.toList((Iterable)longSet) : null;
    }

    @Nullable
    public final T getEntryById$intellij_platform_workspace_storage(long id) {
        return this.getIndex$intellij_platform_workspace_storage().get(id);
    }

    @NotNull
    public final Collection<T> entries$intellij_platform_workspace_storage() {
        return this.getIndex$intellij_platform_workspace_storage().getValues();
    }

    public /* synthetic */ EntityStorageInternalIndex(BidirectionalLongSetMap index, boolean oneToOneAssociation, DefaultConstructorMarker $constructor_marker) {
        this(index, oneToOneAssociation);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u001d*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001dB)\b\u0002\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0004j\b\u0012\u0004\u0012\u00028\u0001`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0003\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00018\u0001H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0017J\u001b\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0001\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u000fH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002R*\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0004j\b\u0012\u0004\u0012\u00028\u0001`\u0005X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "T", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "index", "Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageIndex;", "oneToOneAssociation", "", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;Z)V", "getIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;", "setIndex$intellij_platform_workspace_storage", "(Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongSetMap;)V", "freezed", "", "id", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "entry", "index$intellij_platform_workspace_storage", "(JLjava/lang/Object;)V", "clear", "clear$intellij_platform_workspace_storage", "copyFrom", "another", "copyFrom$intellij_platform_workspace_storage", "startWrite", "toImmutable", "Companion", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nEntityStorageInternalIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityStorageInternalIndex.kt\ncom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n68#2,4:88\n68#2,4:92\n24#2:96\n14#2:97\n*S KotlinDebug\n*F\n+ 1 EntityStorageInternalIndex.kt\ncom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex\n*L\n40#1:88,4\n44#1:92,4\n48#1:96\n82#1:97\n*E\n"})
    public static final class MutableEntityStorageInternalIndex<T>
    extends EntityStorageInternalIndex<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private BidirectionalLongSetMap<T> index;
        private boolean freezed;
        @NotNull
        private static final Logger LOG;

        private MutableEntityStorageInternalIndex(BidirectionalLongSetMap<T> index, boolean oneToOneAssociation) {
            super(index, oneToOneAssociation, null);
            this.index = index;
            this.freezed = true;
        }

        @Override
        @NotNull
        public BidirectionalLongSetMap<T> getIndex$intellij_platform_workspace_storage() {
            return this.index;
        }

        public void setIndex$intellij_platform_workspace_storage(@NotNull BidirectionalLongSetMap<T> bidirectionalLongSetMap) {
            Intrinsics.checkNotNullParameter(bidirectionalLongSetMap, (String)"<set-?>");
            this.index = bidirectionalLongSetMap;
        }

        public final void index$intellij_platform_workspace_storage(long id, @Nullable T entry) {
            this.startWrite();
            if (entry == null) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Removing " + EntityIdKt.asString(id) + " from index");
                }
                this.getIndex$intellij_platform_workspace_storage().remove(id);
                return;
            }
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Index " + id + " to " + entry);
            }
            this.getIndex$intellij_platform_workspace_storage().put(id, entry);
            if (this.getOneToOneAssociation()) {
                LongSet longSet = this.getIndex$intellij_platform_workspace_storage().getKeysByValue(entry);
                if ((longSet != null ? longSet.size() : 0) > 1) {
                    MutableEntityStorageInternalIndex $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(MutableEntityStorageInternalIndex.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("One to one association is violated. Id: " + EntityIdKt.asString(id) + ", Entity: " + entry + ". This id is already associated with " + this.getIndex$intellij_platform_workspace_storage().getKeysByValue(entry));
                }
            }
        }

        public static /* synthetic */ void index$intellij_platform_workspace_storage$default(MutableEntityStorageInternalIndex mutableEntityStorageInternalIndex, long l, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            mutableEntityStorageInternalIndex.index$intellij_platform_workspace_storage(l, object);
        }

        @TestOnly
        public final void clear$intellij_platform_workspace_storage() {
            this.startWrite();
            this.getIndex$intellij_platform_workspace_storage().clear();
        }

        @TestOnly
        public final void copyFrom$intellij_platform_workspace_storage(@NotNull EntityStorageInternalIndex<T> another) {
            Intrinsics.checkNotNullParameter(another, (String)"another");
            this.startWrite();
            this.getIndex$intellij_platform_workspace_storage().putAll(another.getIndex$intellij_platform_workspace_storage());
        }

        private final void startWrite() {
            if (!this.freezed) {
                return;
            }
            this.freezed = false;
            this.setIndex$intellij_platform_workspace_storage(this.getIndex$intellij_platform_workspace_storage().copy());
        }

        @NotNull
        public final EntityStorageInternalIndex<T> toImmutable() {
            this.freezed = true;
            return new EntityStorageInternalIndex(this.getIndex$intellij_platform_workspace_storage(), this.getOneToOneAssociation(), null);
        }

        public /* synthetic */ MutableEntityStorageInternalIndex(BidirectionalLongSetMap index, boolean oneToOneAssociation, DefaultConstructorMarker $constructor_marker) {
            this(index, oneToOneAssociation);
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(MutableEntityStorageInternalIndex.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0002\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "T", "other", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.workspace.storage"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <T> MutableEntityStorageInternalIndex<T> from(@NotNull EntityStorageInternalIndex<T> other) {
                Intrinsics.checkNotNullParameter(other, (String)"other");
                if (other instanceof MutableEntityStorageInternalIndex) {
                    ((MutableEntityStorageInternalIndex)other).freezed = true;
                }
                return new MutableEntityStorageInternalIndex(other.getIndex$intellij_platform_workspace_storage(), other.getOneToOneAssociation(), null);
            }

            @NotNull
            public final Logger getLOG() {
                return LOG;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

