/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.instrumentation.EntityStorageInstrumentation;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u001b\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\"\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00060\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/impl/EntitiesBarrel;", "", "<init>", "()V", "entityFamilies", "", "Lcom/intellij/platform/workspace/storage/impl/EntityFamily;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getEntityFamilies$intellij_platform_workspace_storage", "()Ljava/util/List;", "exists", "", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "get", "clazz", "", "size", "assertConsistency", "", "storage", "Lcom/intellij/platform/workspace/storage/instrumentation/EntityStorageInstrumentation;", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntitiesBarrel;", "Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nEntitiesBarrel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitiesBarrel.kt\ncom/intellij/platform/workspace/storage/impl/EntitiesBarrel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EntityFamily.kt\ncom/intellij/platform/workspace/storage/impl/EntityFamily\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1872#2,2:150\n1872#2,2:153\n1874#2:161\n1874#2:164\n201#3:152\n202#3,2:155\n204#3:158\n206#3:160\n207#3,2:162\n1#4:157\n1#4:159\n*S KotlinDebug\n*F\n+ 1 EntitiesBarrel.kt\ncom/intellij/platform/workspace/storage/impl/EntitiesBarrel\n*L\n124#1:150,2\n128#1:153,2\n128#1:161\n124#1:164\n128#1:152\n128#1:155,2\n128#1:158\n128#1:160\n128#1:162,2\n128#1:157\n*E\n"})
public abstract class EntitiesBarrel {
    private EntitiesBarrel() {
    }

    @NotNull
    public abstract List<EntityFamily<? extends WorkspaceEntity>> getEntityFamilies$intellij_platform_workspace_storage();

    public final boolean exists(long entityId) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.get(EntityIdKt.getClazz(entityId));
        return entityFamily != null ? entityFamily.exists(EntityIdKt.getArrayId(entityId)) : false;
    }

    @Nullable
    public EntityFamily<? extends WorkspaceEntity> get(int clazz) {
        return (EntityFamily)CollectionsKt.getOrNull(this.getEntityFamilies$intellij_platform_workspace_storage(), (int)clazz);
    }

    public final int size() {
        return this.getEntityFamilies$intellij_platform_workspace_storage().size();
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency(@NotNull EntityStorageInstrumentation storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        HashSet<SymbolicEntityId<WorkspaceEntityWithSymbolicId>> symbolicIds = new HashSet<SymbolicEntityId<WorkspaceEntityWithSymbolicId>>();
        Iterable $this$forEachIndexed$iv = this.getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void family;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i = n;
            boolean bl = false;
            if (family == null) continue;
            Class<WorkspaceEntity> clazz = ClassToIntConverterKt.findWorkspaceEntity(i);
            boolean hasSymbolicId = WorkspaceEntityWithSymbolicId.class.isAssignableFrom(clazz);
            void this_$iv = family;
            boolean $i$f$assertConsistency = false;
            Iterable $this$forEachIndexed$iv$iv = this_$iv.getEntities$intellij_platform_workspace_storage();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                boolean bl2;
                boolean bl3;
                void entity$iv;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv$iv;
                int idx$iv = n2;
                boolean bl4 = false;
                if (entity$iv == null) continue;
                boolean bl5 = bl3 = idx$iv == entity$iv.getId();
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl6 = false;
                    String string = "Entity with id " + entity$iv.getId() + " is placed at index " + idx$iv;
                    throw new AssertionError((Object)string);
                }
                void entityData = entity$iv;
                boolean bl7 = false;
                Class<WorkspaceEntity> immutableClass = entityData.getEntityInterface();
                boolean bl8 = Intrinsics.areEqual(clazz, immutableClass);
                if (_Assertions.ENABLED && !bl8) {
                    boolean bl9 = false;
                    String string = StringsKt.trimMargin$default((String)("EntityFamily contains entity data of wrong type:\n                | - EntityFamily class:   " + clazz + "\n                | - entityData class:     " + immutableClass + "\n              "), null, (int)1, null);
                    throw new AssertionError((Object)string);
                }
                if (!hasSymbolicId) continue;
                Object e = entityData.createEntity(storage);
                WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = e instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)e : null;
                SymbolicEntityId<WorkspaceEntityWithSymbolicId> symbolicId = workspaceEntityWithSymbolicId != null ? workspaceEntityWithSymbolicId.getSymbolicId() : null;
                boolean bl10 = bl2 = symbolicId != null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = false;
                    String $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = "Symbolic id expected for " + clazz;
                    throw new AssertionError((Object)$i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42);
                }
                boolean bl11 = bl2 = !CollectionsKt.contains((Iterable)symbolicIds, symbolicId);
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl12 = false;
                    String string = "Duplicated symbolic ids: " + symbolicId;
                    throw new AssertionError((Object)string);
                }
                SymbolicEntityId<WorkspaceEntityWithSymbolicId> symbolicEntityId = symbolicId;
                Intrinsics.checkNotNull(symbolicEntityId);
                symbolicIds.add(symbolicEntityId);
            }
            EntityFamily.access$familyCheck((EntityFamily)this_$iv);
        }
    }

    public /* synthetic */ EntitiesBarrel(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

