/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps;

import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/workspace/jps/JpsEntitySourceFactory;", "", "<init>", "()V", "createJpsEntitySourceForProjectLibrary", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "createJpsEntitySourceForArtifact", "createJpsEntitySource", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource;", "directoryLocation", "", "intellij.platform.workspace.jps"})
public final class JpsEntitySourceFactory {
    @NotNull
    public static final JpsEntitySourceFactory INSTANCE = new JpsEntitySourceFactory();

    private JpsEntitySourceFactory() {
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForProjectLibrary(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        return this.createJpsEntitySource(configLocation, "libraries");
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForArtifact(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        return this.createJpsEntitySource(configLocation, "artifacts");
    }

    private final JpsProjectFileEntitySource createJpsEntitySource(JpsProjectConfigLocation configLocation, String directoryLocation) {
        JpsProjectFileEntitySource jpsProjectFileEntitySource;
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            VirtualFileUrl virtualFileUrl = ((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder().append(directoryLocation);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"append(...)");
            jpsProjectFileEntitySource = new JpsProjectFileEntitySource.FileInDirectory(virtualFileUrl, configLocation);
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            jpsProjectFileEntitySource = new JpsProjectFileEntitySource.ExactFile(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile(), configLocation);
        } else {
            throw new IllegalStateException("Unexpected state".toString());
        }
        return jpsProjectFileEntitySource;
    }
}

