/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.UntraceableException;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ThrowableInterner {
    private static final Interner<Throwable> myTraceInterner = new WeakInterner<Throwable>(new HashingStrategy<Throwable>(){

        @Override
        public int hashCode(Throwable throwable) {
            return ThrowableInterner.computeHashCode(throwable);
        }

        @Override
        public boolean equals(Throwable o1, Throwable o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!Comparing.equal(o1.getClass(), o2.getClass())) {
                return false;
            }
            if (!Objects.equals(o1.getMessage(), o2.getMessage())) {
                return false;
            }
            if (!this.equals(o1.getCause(), o2.getCause())) {
                return false;
            }
            Object[] backtrace1 = ThrowableInterner.getBacktrace(o1);
            Object[] backtrace2 = ThrowableInterner.getBacktrace(o2);
            if (backtrace1 != null && backtrace2 != null) {
                return Arrays.deepEquals(backtrace1, backtrace2);
            }
            return Arrays.equals(o1.getStackTrace(), o2.getStackTrace());
        }
    });
    private static final Field BACKTRACE_FIELD;

    private ThrowableInterner() {
    }

    private static int computeHashCode(@NotNull Throwable throwable) {
        String message;
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(0);
        }
        int mHash = (message = throwable.getMessage()) == null ? 0 : message.hashCode() * 37;
        return mHash + ThrowableInterner.computeTraceHashCode(throwable);
    }

    public static int computeTraceHashCode(@NotNull Throwable throwable) {
        Object[] backtrace;
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(1);
        }
        if ((backtrace = ThrowableInterner.getBacktrace(throwable)) == null) {
            return Arrays.hashCode(throwable.getStackTrace());
        }
        for (Object element : backtrace) {
            if (!(element instanceof Object[])) continue;
            return Arrays.hashCode((Object[])element);
        }
        return 0;
    }

    public static int computeAccurateTraceHashCode(@NotNull Throwable throwable) {
        Object[] backtrace;
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(2);
        }
        if ((backtrace = ThrowableInterner.getBacktrace(throwable)) == null) {
            Object[] trace = throwable instanceof UntraceableException ? null : throwable.getStackTrace();
            return Arrays.hashCode(trace);
        }
        return Arrays.deepHashCode(backtrace);
    }

    private static Object[] getBacktrace(@NotNull Throwable throwable) {
        Object backtrace;
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(3);
        }
        try {
            backtrace = BACKTRACE_FIELD != null ? BACKTRACE_FIELD.get(throwable) : null;
        }
        catch (Throwable e) {
            return null;
        }
        return backtrace instanceof Object[] ? (Object[])backtrace : null;
    }

    public static void clearBacktrace(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(4);
        }
        try {
            throwable.setStackTrace(new StackTraceElement[0]);
            if (BACKTRACE_FIELD != null) {
                BACKTRACE_FIELD.set(throwable, null);
            }
        }
        catch (Throwable e) {
            ExceptionUtilRt.rethrowUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static Throwable intern(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableInterner.$$$reportNull$$$0(5);
        }
        Throwable throwable2 = ThrowableInterner.getBacktrace(throwable) == null ? throwable : myTraceInterner.intern(throwable);
        if (throwable2 == null) {
            ThrowableInterner.$$$reportNull$$$0(6);
        }
        return throwable2;
    }

    public static void clearInternedBacktraces() {
        for (Throwable t : myTraceInterner.getValues()) {
            ThrowableInterner.clearBacktrace(t);
        }
        myTraceInterner.clear();
    }

    static {
        try {
            BACKTRACE_FIELD = Throwable.class.getDeclaredField("backtrace");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        BACKTRACE_FIELD.setAccessible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/objectTree/ThrowableInterner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ThrowableInterner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeHashCode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeTraceHashCode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeAccurateTraceHashCode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBacktrace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearBacktrace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

