/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.roots.ImmutableSyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntheticLibrary {
    @Nullable
    @NonNls
    private final String myComparisonId;
    protected final ExcludeFileCondition myConstantExcludeCondition;

    protected SyntheticLibrary(@Nullable @NonNls String comparisonId, @Nullable ExcludeFileCondition constantExcludeCondition) {
        this.myComparisonId = comparisonId;
        this.myConstantExcludeCondition = constantExcludeCondition;
    }

    public SyntheticLibrary() {
        this(null, null);
    }

    @Nullable
    public final String getComparisonId() {
        return this.myComparisonId;
    }

    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            SyntheticLibrary.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Deprecated
    @Nullable
    public Condition<? super VirtualFile> getExcludeFileCondition() {
        return null;
    }

    @Nullable
    private Condition<VirtualFile> getConstantExcludeConditionAsCondition() {
        if (this.myConstantExcludeCondition == null) {
            return null;
        }
        Collection<VirtualFile> allRoots = this.getAllRoots();
        return this.myConstantExcludeCondition.transformToCondition(allRoots);
    }

    @Nullable
    public final Condition<? super VirtualFile> getUnitedExcludeCondition() {
        Condition<? super VirtualFile> condition = this.getExcludeFileCondition();
        if (condition == null) {
            return this.getConstantExcludeConditionAsCondition();
        }
        Condition<VirtualFile> otherCondition = this.getConstantExcludeConditionAsCondition();
        if (otherCondition == null) {
            return condition;
        }
        return file -> condition.value((VirtualFile)file) || otherCondition.value((VirtualFile)file);
    }

    public boolean isShowInExternalLibrariesNode() {
        return this instanceof ItemPresentation;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull List<? extends VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(2);
        }
        return SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull List<? extends VirtualFile> sourceRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(3);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(4);
        }
        return SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptyList(), excludedRoots, excludeCondition);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(5);
        }
        if (binaryRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(6);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(7);
        }
        return new ImmutableSyntheticLibrary(null, sourceRoots, binaryRoots, excludedRoots, excludeCondition, null);
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull String comparisonId, @NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable ExcludeFileCondition excludeCondition) {
        if (comparisonId == null) {
            SyntheticLibrary.$$$reportNull$$$0(8);
        }
        if (sourceRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(9);
        }
        if (binaryRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(10);
        }
        if (excludedRoots == null) {
            SyntheticLibrary.$$$reportNull$$$0(11);
        }
        return new ImmutableSyntheticLibrary(comparisonId, sourceRoots, binaryRoots, excludedRoots, null, excludeCondition);
    }

    @NotNull
    public final Collection<VirtualFile> getAllRoots() {
        return this.getRoots(true, true);
    }

    @NotNull
    private Collection<VirtualFile> getRoots(boolean includeSources, boolean includeBinaries) {
        if (includeSources && includeBinaries) {
            Collection<VirtualFile> sourceRoots = this.getSourceRoots();
            Collection<VirtualFile> binaryRoots = this.getBinaryRoots();
            if (binaryRoots.isEmpty()) {
                Collection<VirtualFile> collection = sourceRoots;
                if (collection == null) {
                    SyntheticLibrary.$$$reportNull$$$0(12);
                }
                return collection;
            }
            if (sourceRoots.isEmpty()) {
                Collection<VirtualFile> collection = binaryRoots;
                if (collection == null) {
                    SyntheticLibrary.$$$reportNull$$$0(13);
                }
                return collection;
            }
            Set<VirtualFile> set = ContainerUtil.union(sourceRoots, binaryRoots);
            if (set == null) {
                SyntheticLibrary.$$$reportNull$$$0(14);
            }
            return set;
        }
        if (includeSources) {
            Collection<VirtualFile> collection = this.getSourceRoots();
            if (collection == null) {
                SyntheticLibrary.$$$reportNull$$$0(15);
            }
            return collection;
        }
        if (includeBinaries) {
            Collection<VirtualFile> collection = this.getBinaryRoots();
            if (collection == null) {
                SyntheticLibrary.$$$reportNull$$$0(16);
            }
            return collection;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            SyntheticLibrary.$$$reportNull$$$0(17);
        }
        return set;
    }

    public final boolean contains(@NotNull VirtualFile file, boolean includeSources, boolean includeBinaries) {
        Set<? extends VirtualFile> roots;
        if (file == null) {
            SyntheticLibrary.$$$reportNull$$$0(18);
        }
        return VfsUtilCore.isUnder(file, roots = SyntheticLibrary.asSet(this.getRoots(includeSources, includeBinaries))) && !VfsUtilCore.isUnder(file, this.getExcludedRoots());
    }

    public final boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            SyntheticLibrary.$$$reportNull$$$0(19);
        }
        return this.contains(file, true, true);
    }

    @NotNull
    private static Set<? extends VirtualFile> asSet(@NotNull Collection<? extends VirtualFile> collection) {
        if (collection == null) {
            SyntheticLibrary.$$$reportNull$$$0(20);
        }
        return collection instanceof Set ? (Set<Object>)collection : new HashSet<VirtualFile>(collection);
    }

    @NotNull
    private static List<? extends VirtualFile> asList(@NotNull Collection<? extends VirtualFile> collection) {
        if (collection == null) {
            SyntheticLibrary.$$$reportNull$$$0(21);
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<VirtualFile>(collection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonId";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/SyntheticLibrary";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newImmutableLibrary";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "asList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }

    public static interface ExcludeFileCondition {
        public boolean shouldExclude(boolean var1, @NotNull String var2, @NotNull BooleanSupplier var3, @NotNull BooleanSupplier var4, @NotNull BooleanSupplier var5);

        @NotNull
        default public Condition<VirtualFile> transformToCondition(@NotNull Collection<? extends VirtualFile> allRoots) {
            if (allRoots == null) {
                ExcludeFileCondition.$$$reportNull$$$0(0);
            }
            Condition<VirtualFile> condition = file -> this.shouldExclude(file.isDirectory(), file.getName(), () -> allRoots.contains(file), () -> {
                VirtualFile parent = file.getParent();
                return parent != null && allRoots.contains(parent);
            }, () -> {
                VirtualFile parent = file.getParent();
                return parent == null || parent.getParent() != null;
            });
            if (condition == null) {
                ExcludeFileCondition.$$$reportNull$$$0(1);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allRoots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/SyntheticLibrary$ExcludeFileCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/SyntheticLibrary$ExcludeFileCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformToCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "transformToCondition";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

