/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleRootModificationUtil {
    private ModuleRootModificationUtil() {
    }

    public static void addContentRoot(@NotNull Module module, @NotNull String path) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(1);
        }
        ModuleRootModificationUtil.updateModel(module, model -> model.addContentEntry(VfsUtilCore.pathToUrl(path)));
    }

    public static void addContentRoot(@NotNull Module module, @NotNull VirtualFile path) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(3);
        }
        ModuleRootModificationUtil.updateModel(module, model -> model.addContentEntry(path));
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRootUrls, @NotNull List<String> sourceRootUrls) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(4);
        }
        if (classesRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(5);
        }
        if (sourceRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(6);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRootUrls, sourceRootUrls, DependencyScope.COMPILE);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRootUrls, @NotNull List<String> sourceRootUrls, @NotNull DependencyScope scope) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(7);
        }
        if (classesRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(8);
        }
        if (sourceRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(10);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRootUrls, sourceRootUrls, Collections.emptyList(), scope);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRootUrls, @NotNull List<String> sourceRootUrls, @NotNull List<String> excludedRootUrls, @NotNull DependencyScope scope) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(11);
        }
        if (classesRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(12);
        }
        if (sourceRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(13);
        }
        if (excludedRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(15);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRootUrls, sourceRootUrls, excludedRootUrls, scope, false);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRootUrls, @NotNull List<String> sourceRootUrls, @NotNull List<String> excludedRootUrls, @NotNull DependencyScope scope, boolean exported) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(16);
        }
        if (classesRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(17);
        }
        if (sourceRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(18);
        }
        if (excludedRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(20);
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRootUrls, sourceRootUrls, excludedRootUrls, scope, exported, EmptyConsumer.getInstance());
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRootUrls, @NotNull List<String> sourceRootUrls, @NotNull List<String> excludedRootUrls, @NotNull DependencyScope scope, boolean exported, Consumer<? super LibraryEx.ModifiableModelEx> postProcessor) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(21);
        }
        if (classesRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(22);
        }
        if (sourceRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(23);
        }
        if (excludedRootUrls == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(25);
        }
        ModuleRootModificationUtil.updateModel(module, model -> {
            LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(libName);
            LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
            for (String rootUrl : classesRootUrls) {
                libraryModel.addRoot(rootUrl, OrderRootType.CLASSES);
            }
            for (String rootUrl : sourceRootUrls) {
                libraryModel.addRoot(rootUrl, OrderRootType.SOURCES);
            }
            for (String excludedUrl : excludedRootUrls) {
                libraryModel.addExcludedRoot(excludedUrl);
            }
            LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
            assert (entry != null) : library;
            entry.setScope(scope);
            entry.setExported(exported);
            postProcessor.consume(libraryModel);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(libraryModel::commit));
        });
    }

    public static void addModuleLibrary(@NotNull Module module, @NotNull String classesRootUrl) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(26);
        }
        if (classesRootUrl == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(27);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && classesRootUrl.endsWith(".jar")) assert (false) : "jar file is expected, local file is used";
        ModuleRootModificationUtil.addModuleLibrary(module, null, Collections.singletonList(classesRootUrl), Collections.emptyList());
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(28);
        }
        if (library == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(29);
        }
        ModuleRootModificationUtil.addDependency(module, library, DependencyScope.COMPILE, false);
    }

    public static void removeDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(30);
        }
        if (library == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(31);
        }
        ModuleRootModificationUtil.updateModel(module, model -> {
            LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
            if (entry == null) {
                throw new IllegalArgumentException("Library " + library.getName() + " is not found in dependencies of module " + module.getName());
            }
            model.removeOrderEntry(entry);
        });
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(32);
        }
        if (library == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(34);
        }
        ModuleRootModificationUtil.updateModel(module, model -> {
            LibraryOrderEntry entry = model.addLibraryEntry(library);
            entry.setExported(exported);
            entry.setScope(scope);
        });
    }

    public static void setModuleSdk(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(35);
        }
        ModuleRootModificationUtil.updateModel(module, model -> model.setSdk(sdk));
    }

    public static void setSdkInherited(@NotNull Module module) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(36);
        }
        ModuleRootModificationUtil.updateModel(module, model -> model.inheritSdk());
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(37);
        }
        if (to == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(38);
        }
        ModuleRootModificationUtil.addDependency(from, to, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        if (from == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(39);
        }
        if (to == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(41);
        }
        ModuleRootModificationUtil.updateModel(from, model -> {
            ModuleOrderEntry entry = model.addModuleOrderEntry(to);
            entry.setScope(scope);
            entry.setExported(exported);
        });
    }

    public static void updateModel(@NotNull Module module, @NotNull Consumer<? super ModifiableRootModel> task) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(42);
        }
        if (task == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(43);
        }
        ModuleRootModificationUtil.modifyModel(module, model -> {
            task.consume((ModifiableRootModel)model);
            return Boolean.TRUE;
        });
    }

    public static void modifyModel(@NotNull Module module, @NotNull Function<? super ModifiableRootModel, Boolean> modifier) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(44);
        }
        if (modifier == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(45);
        }
        ModifiableRootModel model = ReadAction.compute(() -> ModuleRootManager.getInstance(module).getModifiableModel());
        try {
            if (modifier.apply(model).booleanValue()) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (!module.isDisposed()) {
                        WriteAction.run(model::commit);
                    }
                });
            }
        }
        finally {
            if (!model.isDisposed()) {
                model.dispose();
            }
        }
    }

    public static void updateExcludedFolders(@NotNull Module module, @NotNull VirtualFile contentRoot, @NotNull Collection<String> urlsToUnExclude, @NotNull Collection<String> urlsToExclude) {
        if (module == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(46);
        }
        if (contentRoot == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(47);
        }
        if (urlsToUnExclude == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(48);
        }
        if (urlsToExclude == null) {
            ModuleRootModificationUtil.$$$reportNull$$$0(49);
        }
        ModuleRootModificationUtil.updateModel(module, modifiableModel -> {
            for (ContentEntry contentEntry : modifiableModel.getContentEntries()) {
                if (!contentRoot.equals(contentEntry.getFile())) continue;
                for (String url : urlsToUnExclude) {
                    contentEntry.removeExcludeFolder(url);
                }
                for (String url : urlsToExclude) {
                    contentEntry.addExcludeFolder(url);
                }
                break;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRootUrls";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootUrls";
                break;
            }
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRootUrls";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRootUrl";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsToUnExclude";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsToExclude";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ModuleRootModificationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addContentRoot";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleLibrary";
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependency";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDependency";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "setModuleSdk";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "setSdkInherited";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "updateModel";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyModel";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "updateExcludedFolders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

