/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.projectModel.ProjectModelBundle;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum DependencyScope {
    COMPILE(ProjectModelBundle.messagePointer("dependency.scope.compile", new Object[0]), true, true, true, true),
    TEST(ProjectModelBundle.messagePointer("dependency.scope.test", new Object[0]), false, false, true, true),
    RUNTIME(ProjectModelBundle.messagePointer("dependency.scope.runtime", new Object[0]), false, true, false, true),
    PROVIDED(ProjectModelBundle.messagePointer("dependency.scope.provided", new Object[0]), true, false, true, true);

    private final @NotNull Supplier<@NlsContexts.ListItem String> myDisplayName;
    private final boolean myForProductionCompile;
    private final boolean myForProductionRuntime;
    private final boolean myForTestCompile;
    private final boolean myForTestRuntime;
    @NonNls
    public static final String SCOPE_ATTR = "scope";

    private DependencyScope(Supplier<String> displayName, boolean forProductionCompile, boolean forProductionRuntime, boolean forTestCompile, boolean forTestRuntime) {
        if (displayName == null) {
            DependencyScope.$$$reportNull$$$0(0);
        }
        this.myDisplayName = displayName;
        this.myForProductionCompile = forProductionCompile;
        this.myForProductionRuntime = forProductionRuntime;
        this.myForTestCompile = forTestCompile;
        this.myForTestRuntime = forTestRuntime;
    }

    @NotNull
    public static DependencyScope coveringUseCasesOf(@NotNull DependencyScope scope1, @NotNull DependencyScope scope2) {
        if (scope1 == null) {
            DependencyScope.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            DependencyScope.$$$reportNull$$$0(2);
        }
        if (scope1.coversUseCasesOf(scope2)) {
            DependencyScope dependencyScope = scope1;
            if (dependencyScope == null) {
                DependencyScope.$$$reportNull$$$0(3);
            }
            return dependencyScope;
        }
        if (scope2.coversUseCasesOf(scope1)) {
            DependencyScope dependencyScope = scope2;
            if (dependencyScope == null) {
                DependencyScope.$$$reportNull$$$0(4);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = COMPILE;
        if (dependencyScope == null) {
            DependencyScope.$$$reportNull$$$0(5);
        }
        return dependencyScope;
    }

    @NotNull
    public static DependencyScope readExternal(@NotNull Element element) {
        String scope;
        if (element == null) {
            DependencyScope.$$$reportNull$$$0(6);
        }
        if ((scope = element.getAttributeValue(SCOPE_ATTR)) != null) {
            DependencyScope dependencyScope;
            try {
                dependencyScope = DependencyScope.valueOf(scope);
            }
            catch (IllegalArgumentException e) {
                DependencyScope dependencyScope2 = COMPILE;
                if (dependencyScope2 == null) {
                    DependencyScope.$$$reportNull$$$0(8);
                }
                return dependencyScope2;
            }
            if (dependencyScope == null) {
                DependencyScope.$$$reportNull$$$0(7);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = COMPILE;
        if (dependencyScope == null) {
            DependencyScope.$$$reportNull$$$0(9);
        }
        return dependencyScope;
    }

    public void writeExternal(Element element) {
        if (this != COMPILE) {
            element.setAttribute(SCOPE_ATTR, this.name());
        }
    }

    @NotNull
    @NlsContexts.ListItem
    public String getDisplayName() {
        String string = this.myDisplayName.get();
        if (string == null) {
            DependencyScope.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isForProductionCompile() {
        return this.myForProductionCompile;
    }

    public boolean isForProductionRuntime() {
        return this.myForProductionRuntime;
    }

    public boolean isForTestCompile() {
        return this.myForTestCompile;
    }

    public boolean isForTestRuntime() {
        return this.myForTestRuntime;
    }

    public boolean coversUseCasesOf(@NotNull DependencyScope that) {
        if (that == null) {
            DependencyScope.$$$reportNull$$$0(11);
        }
        if (this == that) {
            return true;
        }
        boolean thatCoversUseCaseNotCoveredByThis = that.myForProductionCompile && !this.myForProductionCompile || that.myForProductionRuntime && !this.myForProductionRuntime || that.myForTestCompile && !this.myForTestCompile || that.myForTestRuntime && !this.myForTestRuntime;
        return !thatCoversUseCaseNotCoveredByThis;
    }

    @NlsContexts.ListItem
    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/DependencyScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/DependencyScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "coveringUseCasesOf";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "coveringUseCasesOf";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "coversUseCasesOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

