/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SdkTypeId {
    @NotNull
    public String getName();

    @Nullable
    public String getVersionString(@NotNull Sdk var1);

    public void saveAdditionalData(@NotNull SdkAdditionalData var1, @NotNull Element var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk var1, @NotNull Element var2);

    default public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkTypeId.$$$reportNull$$$0(0);
        }
        return true;
    }

    @NotNull
    default public Comparator<Sdk> versionComparator() {
        Comparator<String> versionStringComparator = this.versionStringComparator();
        Comparator comparator = (sdk1, sdk2) -> {
            if (!1.$assertionsDisabled && sdk1.getSdkType() != this) {
                throw new AssertionError(sdk1);
            }
            if (!1.$assertionsDisabled && sdk2.getSdkType() != this) {
                throw new AssertionError(sdk2);
            }
            return versionStringComparator.compare(sdk1.getVersionString(), sdk2.getVersionString());
        };
        if (comparator == null) {
            SdkTypeId.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    @NotNull
    default public Comparator<String> versionStringComparator() {
        Comparator comparator = (v1, v2) -> StringUtil.compareVersionNumbers(v1, v2);
        if (comparator == null) {
            SdkTypeId.$$$reportNull$$$0(2);
        }
        return comparator;
    }

    default public boolean allowWslSdkForLocalProject() {
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SdkTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SdkTypeId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "versionComparator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "versionStringComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

