/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Intervals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 #2\u00020\u0001:\u0004 !\"#B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0007H&J\b\u0010\t\u001a\u00020\u0007H&J\b\u0010\n\u001a\u00020\u0007H&J\u001c\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\rH&J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u00a6\u0004J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u00a6\u0004J\t\u0010\u0011\u001a\u00020\u0000H\u00a6\u0002J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00a6\u0002J\b\u0010\u0013\u001a\u00020\u0007H&J\b\u0010\u0014\u001a\u00020\rH&J\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\rH&J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0007H&J\b\u0010\u0019\u001a\u00020\u0005H&J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000H&J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\r\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/detector/api/Intervals;", "", "<init>", "()V", "toString", "", "fromInclusive", "", "fromInclusiveMinor", "toExclusive", "toExclusiveMinor", "variable", "compact", "", "and", "other", "or", "not", "equals", "hashCode", "isEmpty", "isNotEmpty", "isAll", "contains", "value", "serialize", "isAtLeast", "alwaysAtLeast", "minSdk", "apiLevel", "everHigher", "isOpenEnded", "MajorMinor", "Span", "Spans", "Companion", "Lcom/android/tools/lint/detector/api/Intervals$Span;", "Lcom/android/tools/lint/detector/api/Intervals$Spans;", "lint-api"})
public abstract class Intervals {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAJOR_SHIFT = 6;
    private static final int INFINITY = MajorMinor.constructor-impl(Integer.MAX_VALUE);
    private static final int ZERO = MajorMinor.constructor-impl(1, 0);
    private static final int API_LEVEL_DELTA = 64;
    private static final int MINOR_MASK = 63;
    @NotNull
    private static final Intervals NONE = new Span(ZERO, ZERO, null);
    @NotNull
    private static final Intervals ALL = new Span(ZERO, INFINITY, null);

    private Intervals() {
    }

    @NotNull
    public String toString() {
        return Intervals.toString$default(this, null, false, 1, null);
    }

    public abstract int fromInclusive();

    public abstract int fromInclusiveMinor();

    public abstract int toExclusive();

    public abstract int toExclusiveMinor();

    @NotNull
    public abstract String toString(@NotNull String var1, boolean var2);

    public static /* synthetic */ String toString$default(Intervals intervals, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toString");
        }
        if ((n & 1) != 0) {
            string = "x";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return intervals.toString(string, bl);
    }

    @NotNull
    public abstract Intervals and(@NotNull Intervals var1);

    @NotNull
    public abstract Intervals or(@NotNull Intervals var1);

    @NotNull
    public abstract Intervals not();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract boolean isEmpty();

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public abstract boolean isAll();

    public abstract boolean contains(int var1);

    @NotNull
    public abstract String serialize();

    public abstract boolean isAtLeast(@NotNull Intervals var1);

    public final boolean alwaysAtLeast(@NotNull Intervals minSdk) {
        Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
        return Intrinsics.areEqual((Object)minSdk.and(this), (Object)minSdk);
    }

    public final boolean alwaysAtLeast(int apiLevel) {
        Intervals minSdk = com.android.tools.lint.detector.api.Intervals$Companion.atLeast$default(Companion, apiLevel, 0, 2, null);
        return Intrinsics.areEqual((Object)minSdk.and(this), (Object)minSdk);
    }

    public final boolean everHigher(int apiLevel) {
        Intervals minSdk = com.android.tools.lint.detector.api.Intervals$Companion.atLeast$default(Companion, apiLevel + 1, 0, 2, null);
        return minSdk.and(this).isNotEmpty();
    }

    public final boolean isOpenEnded() {
        return Companion.isInfinity(this.toExclusive());
    }

    public /* synthetic */ Intervals(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J&\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010 \u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J*\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J*\u0010'\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005J\u0018\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020#H\u0002J\u001f\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b0\u00101R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001d\u00a8\u00062"}, d2={"Lcom/android/tools/lint/detector/api/Intervals$Companion;", "", "<init>", "()V", "MAJOR_SHIFT", "", "INFINITY", "Lcom/android/tools/lint/detector/api/Intervals$MajorMinor;", "I", "ZERO", "API_LEVEL_DELTA", "MINOR_MASK", "exactly", "Lcom/android/tools/lint/detector/api/Intervals;", "major", "minor", "atLeast", "atMost", "toExclusive", "below", "range", "fromInclusive", "fromInclusiveMinor", "toExclusiveMinor", "deserialize", "s", "", "NONE", "getNONE", "()Lcom/android/tools/lint/detector/api/Intervals;", "ALL", "getALL", "create", "spans", "", "Lcom/android/tools/lint/detector/api/Intervals$Span;", "joinIntervals", "intervals1", "intervals2", "intersectIntervals", "isInfinity", "", "level", "isNotXInterval", "first", "adjacent", "left", "right", "adjacent-H6P1fLs", "(II)Z", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nIntervals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Intervals.kt\ncom/android/tools/lint/detector/api/Intervals$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,661:1\n1557#2:662\n1628#2,3:663\n*S KotlinDebug\n*F\n+ 1 Intervals.kt\ncom/android/tools/lint/detector/api/Intervals$Companion\n*L\n498#1:662\n498#1:663,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intervals exactly(int major) {
            return new Span(major, 0, major + 1, 0);
        }

        @NotNull
        public final Intervals exactly(int major, int minor) {
            return new Span(major, minor, major, minor + 1);
        }

        @NotNull
        public final Intervals atLeast(int major, int minor) {
            return new Span(MajorMinor.constructor-impl(major, minor), INFINITY, null);
        }

        public static /* synthetic */ Intervals atLeast$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atLeast(n, n2);
        }

        @NotNull
        public final Intervals atMost(int toExclusive) {
            return new Span(1, 0, toExclusive + 1, 0);
        }

        @NotNull
        public final Intervals below(int toExclusive, int minor) {
            return new Span(1, 0, toExclusive, minor);
        }

        public static /* synthetic */ Intervals below$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.below(n, n2);
        }

        @NotNull
        public final Intervals range(int fromInclusive, int toExclusive) {
            return new Span(fromInclusive, 0, toExclusive, 0);
        }

        @NotNull
        public final Intervals range(int fromInclusive, int fromInclusiveMinor, int toExclusive, int toExclusiveMinor) {
            return new Span(fromInclusive, fromInclusiveMinor, toExclusive, toExclusiveMinor);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Intervals deserialize(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (StringsKt.contains$default((CharSequence)s, (char)',', (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                char[] cArray = new char[]{','};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intervals intervals = Companion.deserialize((String)it);
                    Intrinsics.checkNotNull((Object)intervals, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.Intervals.Span");
                    collection.add((Span)intervals);
                }
                List spans = (List)destination$iv$iv;
                return this.create(spans);
            }
            if (Intrinsics.areEqual((Object)s, (Object)"0")) {
                return this.getNONE();
            }
            if (StringsKt.endsWith$default((String)s, (String)"-\u221e", (boolean)false, (int)2, null)) {
                int fromDot = StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)0, (boolean)false, (int)6, null);
                int from = 0;
                int fromMinor = 0;
                if (fromDot != -1) {
                    String string = s.substring(0, fromDot);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    from = Integer.parseInt(string);
                    String string2 = s.substring(fromDot + 1, s.length() - 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    fromMinor = Integer.parseInt(string2);
                } else {
                    String string = s.substring(0, s.length() - 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    from = Integer.parseInt(string);
                    fromMinor = 0;
                }
                return new Span(MajorMinor.constructor-impl(from, fromMinor), INFINITY, null);
            }
            int separator = StringsKt.indexOf$default((CharSequence)s, (char)'-', (int)0, (boolean)false, (int)6, null);
            int fromInclusive = 0;
            int fromInclusiveMinor = 0;
            int toExclusive = 0;
            int toExclusiveMinor = 0;
            int fromDot = StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)0, (boolean)false, (int)6, null);
            int toDot = StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(separator + 1), (boolean)false, (int)4, null);
            if (fromDot != -1 && fromDot < separator) {
                String string = s.substring(0, fromDot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                fromInclusive = Integer.parseInt(string);
                String string3 = s.substring(fromDot + 1, separator);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                fromInclusiveMinor = Integer.parseInt(string3);
            } else {
                String string = s.substring(0, separator);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                fromInclusive = Integer.parseInt(string);
                fromInclusiveMinor = 0;
            }
            if (toDot != -1) {
                String string = s.substring(separator + 1, toDot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                toExclusive = Integer.parseInt(string);
                String string4 = s.substring(toDot + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                toExclusiveMinor = Integer.parseInt(string4);
            } else {
                String string = s.substring(separator + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                toExclusive = Integer.parseInt(string);
                toExclusiveMinor = 0;
            }
            return new Span(fromInclusive, fromInclusiveMinor, toExclusive, toExclusiveMinor);
        }

        @NotNull
        public final Intervals getNONE() {
            return NONE;
        }

        @NotNull
        public final Intervals getALL() {
            return ALL;
        }

        private final Intervals create(List<Span> spans) {
            return spans.isEmpty() ? this.getNONE() : (spans.size() == 1 ? (Intervals)CollectionsKt.first(spans) : (Intervals)new Spans(spans));
        }

        private final List<Span> joinIntervals(List<Span> intervals1, List<Span> intervals2) {
            List mergedIntervals = new ArrayList();
            int i = 0;
            int j = 0;
            while (i < intervals1.size() || j < intervals2.size()) {
                if (i == intervals1.size()) {
                    mergedIntervals.add(intervals2.get(j++));
                    continue;
                }
                if (j == intervals2.size()) {
                    mergedIntervals.add(intervals1.get(i++));
                    continue;
                }
                Span current1 = intervals1.get(i);
                Span current2 = intervals2.get(j);
                if (MajorMinor.compareTo-a9gHCQw(current1.getTo-v2ZXzM8(), current2.getFrom-v2ZXzM8()) <= 0) {
                    mergedIntervals.add(current1);
                    ++i;
                    continue;
                }
                if (MajorMinor.compareTo-a9gHCQw(current2.getTo-v2ZXzM8(), current1.getFrom-v2ZXzM8()) <= 0) {
                    mergedIntervals.add(current2);
                    ++j;
                    continue;
                }
                int newFrom = ((MajorMinor)ComparisonsKt.minOf((Comparable)MajorMinor.box-impl(current1.getFrom-v2ZXzM8()), (Comparable)MajorMinor.box-impl(current2.getFrom-v2ZXzM8()))).unbox-impl();
                int newTo = ((MajorMinor)ComparisonsKt.maxOf((Comparable)MajorMinor.box-impl(current1.getTo-v2ZXzM8()), (Comparable)MajorMinor.box-impl(current2.getTo-v2ZXzM8()))).unbox-impl();
                mergedIntervals.add(new Span(newFrom, newTo, null));
                if (MajorMinor.compareTo-a9gHCQw(current1.getTo-v2ZXzM8(), current2.getTo-v2ZXzM8()) < 0) {
                    ++i;
                    continue;
                }
                ++j;
            }
            return mergedIntervals;
        }

        private final List<Span> intersectIntervals(List<Span> intervals1, List<Span> intervals2) {
            List intersectedIntervals = new ArrayList();
            int i = 0;
            int j = 0;
            while (i < intervals1.size() && j < intervals2.size()) {
                Span current1 = intervals1.get(i);
                Span current2 = intervals2.get(j);
                if (MajorMinor.compareTo-a9gHCQw(current1.getTo-v2ZXzM8(), current2.getFrom-v2ZXzM8()) > 0 && MajorMinor.compareTo-a9gHCQw(current2.getTo-v2ZXzM8(), current1.getFrom-v2ZXzM8()) > 0) {
                    int newFrom = ((MajorMinor)ComparisonsKt.maxOf((Comparable)MajorMinor.box-impl(current1.getFrom-v2ZXzM8()), (Comparable)MajorMinor.box-impl(current2.getFrom-v2ZXzM8()))).unbox-impl();
                    int newTo = ((MajorMinor)ComparisonsKt.minOf((Comparable)MajorMinor.box-impl(current1.getTo-v2ZXzM8()), (Comparable)MajorMinor.box-impl(current2.getTo-v2ZXzM8()))).unbox-impl();
                    intersectedIntervals.add(new Span(newFrom, newTo, null));
                }
                if (MajorMinor.compareTo-a9gHCQw(current1.getTo-v2ZXzM8(), current2.getTo-v2ZXzM8()) < 0) {
                    ++i;
                    continue;
                }
                ++j;
            }
            return intersectedIntervals;
        }

        public final boolean isInfinity(int level) {
            return level == INFINITY;
        }

        private final boolean isNotXInterval(Span first, Span adjacent) {
            return MajorMinor.equals-impl0(first.getFrom-v2ZXzM8(), ZERO) && MajorMinor.equals-impl0(adjacent.getTo-v2ZXzM8(), INFINITY) && this.adjacent-H6P1fLs(first.getTo-v2ZXzM8(), adjacent.getFrom-v2ZXzM8());
        }

        private final boolean adjacent-H6P1fLs(int left, int right) {
            return left + 1 == right || left + 64 == right && MajorMinor.getMinor-impl(left) == 0 && MajorMinor.getMinor-impl(right) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0083@\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\bJ\u000f\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\u0088\u0001\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/detector/api/Intervals$MajorMinor;", "", "bits", "", "constructor-impl", "(I)I", "major", "minor", "(II)I", "getBits", "()I", "getMajor-impl", "getMinor-impl", "compareTo", "other", "compareTo-a9gHCQw", "toString", "", "toString-impl", "(I)Ljava/lang/String;", "equals", "", "", "equals-impl", "(ILjava/lang/Object;)Z", "hashCode", "hashCode-impl", "lint-api"})
    private static final class MajorMinor
    implements Comparable<MajorMinor> {
        private final int bits;

        public final int getBits() {
            return this.bits;
        }

        public static int constructor-impl(int major, int minor) {
            return MajorMinor.constructor-impl((major << 6) + minor);
        }

        public static final int getMajor-impl(int arg0) {
            return MajorMinor.equals-impl0(arg0, INFINITY) ? Integer.MAX_VALUE : arg0 >> 6;
        }

        public static final int getMinor-impl(int arg0) {
            return arg0 & 0x3F;
        }

        public static int compareTo-a9gHCQw(int arg0, int other) {
            return Intrinsics.compare((int)arg0, (int)other);
        }

        public int compareTo-a9gHCQw(int other) {
            return MajorMinor.compareTo-a9gHCQw(this.bits, other);
        }

        @NotNull
        public static String toString-impl(int arg0) {
            return MajorMinor.getMinor-impl(arg0) > 0 ? MajorMinor.getMajor-impl(arg0) + "." + MajorMinor.getMinor-impl(arg0) : String.valueOf(MajorMinor.getMajor-impl(arg0));
        }

        @NotNull
        public String toString() {
            return MajorMinor.toString-impl(this.bits);
        }

        public static int hashCode-impl(int arg0) {
            return Integer.hashCode(arg0);
        }

        public int hashCode() {
            return MajorMinor.hashCode-impl(this.bits);
        }

        public static boolean equals-impl(int arg0, Object other) {
            if (!(other instanceof MajorMinor)) {
                return false;
            }
            int n = ((MajorMinor)other).unbox-impl();
            return arg0 == n;
        }

        public boolean equals(Object other) {
            return MajorMinor.equals-impl(this.bits, other);
        }

        private /* synthetic */ MajorMinor(int bits) {
            this.bits = bits;
        }

        public static int constructor-impl(int bits) {
            return bits;
        }

        public static final /* synthetic */ MajorMinor box-impl(int v) {
            return new MajorMinor(v);
        }

        public final /* synthetic */ int unbox-impl() {
            return this.bits;
        }

        public static final boolean equals-impl0(int p1, int p2) {
            return p1 == p2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\fJ\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0096\u0004J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\u0013\u0010!\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020\bH\u0016R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/detector/api/Intervals$Span;", "Lcom/android/tools/lint/detector/api/Intervals;", "from", "Lcom/android/tools/lint/detector/api/Intervals$MajorMinor;", "to", "<init>", "(IILkotlin/jvm/internal/DefaultConstructorMarker;)V", "fromInclusive", "", "fromInclusiveMinor", "toExclusive", "toExclusiveMinor", "(IIII)V", "getFrom-v2ZXzM8", "()I", "I", "getTo-v2ZXzM8", "isEmpty", "", "intersects", "other", "contains", "value", "isAtLeast", "serialize", "", "not", "and", "or", "toString", "variable", "compact", "isAll", "equals", "", "hashCode", "lint-api"})
    private static final class Span
    extends Intervals {
        private final int from;
        private final int to;

        private Span(int from, int to) {
            super(null);
            this.from = from;
            this.to = to;
        }

        public final int getFrom-v2ZXzM8() {
            return this.from;
        }

        public final int getTo-v2ZXzM8() {
            return this.to;
        }

        public Span(int fromInclusive, int fromInclusiveMinor, int toExclusive, int toExclusiveMinor) {
            this(MajorMinor.constructor-impl(fromInclusive, fromInclusiveMinor), MajorMinor.constructor-impl(toExclusive, toExclusiveMinor), null);
        }

        @Override
        public int fromInclusive() {
            return this.isEmpty() ? -1 : MajorMinor.getMajor-impl(this.from);
        }

        @Override
        public int fromInclusiveMinor() {
            return MajorMinor.getMinor-impl(this.from);
        }

        @Override
        public int toExclusive() {
            return MajorMinor.getMajor-impl(this.to);
        }

        @Override
        public int toExclusiveMinor() {
            return MajorMinor.getMinor-impl(this.to);
        }

        @Override
        public boolean isEmpty() {
            return MajorMinor.equals-impl0(this.from, this.to);
        }

        private final boolean intersects(Span $this$intersects, Span other) {
            return MajorMinor.compareTo-a9gHCQw($this$intersects.from, other.to) <= 0 && MajorMinor.compareTo-a9gHCQw(other.from, $this$intersects.to) <= 0;
        }

        @Override
        public boolean contains(int value) {
            return RangesKt.rangeUntil((Comparable)MajorMinor.box-impl(this.from), (Comparable)MajorMinor.box-impl(this.to)).contains((Comparable)MajorMinor.box-impl(MajorMinor.constructor-impl(value, 0)));
        }

        @Override
        public boolean isAtLeast(@NotNull Intervals other) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intervals intervals = other;
            if (intervals instanceof Span) {
                bl = MajorMinor.compareTo-a9gHCQw(this.from, ((Span)other).from) >= 0;
            } else if (intervals instanceof Spans) {
                bl = MajorMinor.compareTo-a9gHCQw(this.from, ((Span)CollectionsKt.first(((Spans)other).getSpans())).from) >= 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        @Override
        @NotNull
        public String serialize() {
            if (this.isEmpty()) {
                return "0";
            }
            StringBuilder sb = new StringBuilder();
            int fromInclusive = this.fromInclusive();
            int fromInclusiveMinor = this.fromInclusiveMinor();
            sb.append(String.valueOf(fromInclusive));
            if (fromInclusiveMinor > 0) {
                sb.append('.').append(String.valueOf(fromInclusiveMinor));
            }
            sb.append('-');
            if (MajorMinor.equals-impl0(this.to, INFINITY)) {
                sb.append('\u221e');
            } else {
                int toExclusive = this.toExclusive();
                int toExclusiveMinor = this.toExclusiveMinor();
                sb.append(String.valueOf(toExclusive));
                if (toExclusiveMinor > 0) {
                    sb.append('.').append(String.valueOf(toExclusiveMinor));
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        @NotNull
        public Intervals not() {
            Intervals intervals;
            if (Intrinsics.areEqual((Object)this, (Object)Companion.getALL())) {
                intervals = Companion.getNONE();
            } else if (Intrinsics.areEqual((Object)this, (Object)Companion.getNONE())) {
                intervals = Companion.getALL();
            } else if (MajorMinor.equals-impl0(this.from, ZERO)) {
                intervals = new Span(this.to, INFINITY, null);
            } else if (MajorMinor.equals-impl0(this.to, INFINITY)) {
                intervals = new Span(ZERO, this.from, null);
            } else {
                Object[] objectArray = new Span[]{new Span(ZERO, this.from, null), new Span(this.to, INFINITY, null)};
                intervals = new Spans(CollectionsKt.listOf((Object[])objectArray));
            }
            return intervals;
        }

        @Override
        @NotNull
        public Intervals and(@NotNull Intervals other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intervals intervals = other;
            if (intervals instanceof Span) {
                int start = Math.max(this.from, ((Span)other).from);
                int end = Math.min(this.to, ((Span)other).to);
                return start >= end ? Companion.getNONE() : (start == this.from && end == this.to ? (Intervals)this : (start == ((Span)other).from && end == ((Span)other).to ? other : (Intervals)new Span(MajorMinor.constructor-impl(start), MajorMinor.constructor-impl(end), null)));
            }
            if (intervals instanceof Spans) {
                return ((Spans)other).and(this);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public Intervals or(@NotNull Intervals other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intervals intervals = other;
            if (intervals instanceof Span) {
                if (this.intersects(this, (Span)other)) {
                    int start = Math.min(this.from, ((Span)other).from);
                    int end = Math.max(this.to, ((Span)other).to);
                    return start >= end ? Companion.getNONE() : (start == this.from && end == this.to ? (Intervals)this : (start == ((Span)other).from && end == ((Span)other).to ? other : (Intervals)new Span(MajorMinor.constructor-impl(start), MajorMinor.constructor-impl(end), null)));
                }
                Intervals first = null;
                Intervals second = null;
                if (MajorMinor.compareTo-a9gHCQw(this.from, ((Span)other).from) < 0) {
                    first = this;
                    second = other;
                } else {
                    first = other;
                    second = this;
                }
                Object[] objectArray = new Span[]{first, second};
                return new Spans(CollectionsKt.listOf((Object[])objectArray));
            }
            if (intervals instanceof Spans) {
                return ((Spans)other).or(this);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public String toString(@NotNull String variable, boolean compact) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            String fromString = MajorMinor.toString-impl(this.from);
            String toString2 = MajorMinor.toString-impl(this.to);
            return Companion.adjacent-H6P1fLs(this.from, this.to) ? variable + " = " + fromString : (MajorMinor.compareTo-a9gHCQw(this.to, this.from) <= 0 ? "No " + variable + "s" : (MajorMinor.equals-impl0(this.from, ZERO) ? (MajorMinor.equals-impl0(this.to, INFINITY) ? "All " + variable + "s" : variable + " < " + toString2) : (MajorMinor.equals-impl0(this.to, INFINITY) ? variable + " \u2265 " + fromString : (compact ? fromString + " \u2264 " + variable + " < " + toString2 : variable + " \u2265 " + fromString + " and " + variable + " < " + toString2))));
        }

        @Override
        public boolean isAll() {
            return MajorMinor.equals-impl0(this.from, ZERO) && MajorMinor.equals-impl0(this.to, INFINITY);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.Intervals.Span");
            Span cfr_ignored_0 = (Span)other;
            if (MajorMinor.compareTo-a9gHCQw(this.from, this.to) >= 0) {
                return MajorMinor.compareTo-a9gHCQw(((Span)other).from, ((Span)other).to) >= 0;
            }
            return MajorMinor.equals-impl0(this.from, ((Span)other).from) && MajorMinor.equals-impl0(this.to, ((Span)other).to);
        }

        @Override
        public int hashCode() {
            return 31 * this.fromInclusive() + this.toExclusive();
        }

        public /* synthetic */ Span(int from, int to, DefaultConstructorMarker $constructor_marker) {
            this(from, to);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0011\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0096\u0004J\t\u0010\u001b\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\u0013\u0010\u001d\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\nH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/detector/api/Intervals$Spans;", "Lcom/android/tools/lint/detector/api/Intervals;", "spans", "", "Lcom/android/tools/lint/detector/api/Intervals$Span;", "<init>", "(Ljava/util/List;)V", "getSpans", "()Ljava/util/List;", "fromInclusive", "", "fromInclusiveMinor", "toExclusive", "toExclusiveMinor", "isEmpty", "", "isAll", "contains", "value", "isAtLeast", "other", "toString", "", "variable", "compact", "or", "and", "not", "serialize", "equals", "", "hashCode", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nIntervals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Intervals.kt\ncom/android/tools/lint/detector/api/Intervals$Spans\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,661:1\n1755#2,3:662\n*S KotlinDebug\n*F\n+ 1 Intervals.kt\ncom/android/tools/lint/detector/api/Intervals$Spans\n*L\n383#1:662,3\n*E\n"})
    private static final class Spans
    extends Intervals {
        @NotNull
        private final List<Span> spans;

        public Spans(@NotNull List<Span> spans) {
            Intrinsics.checkNotNullParameter(spans, (String)"spans");
            super(null);
            this.spans = spans;
        }

        @NotNull
        public final List<Span> getSpans() {
            return this.spans;
        }

        @Override
        public int fromInclusive() {
            if (this.spans.isEmpty()) {
                return 1;
            }
            return ((Span)CollectionsKt.first(this.spans)).fromInclusive();
        }

        @Override
        public int fromInclusiveMinor() {
            if (this.spans.isEmpty()) {
                return 0;
            }
            return ((Span)CollectionsKt.first(this.spans)).fromInclusiveMinor();
        }

        @Override
        public int toExclusive() {
            if (this.spans.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return ((Span)CollectionsKt.last(this.spans)).toExclusive();
        }

        @Override
        public int toExclusiveMinor() {
            if (this.spans.isEmpty()) {
                return 0;
            }
            return ((Span)CollectionsKt.last(this.spans)).toExclusiveMinor();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isAll() {
            return false;
        }

        @Override
        public boolean contains(int value) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.spans;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Span it = (Span)element$iv;
                        boolean bl2 = false;
                        if (!it.contains(value)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean isAtLeast(@NotNull Intervals other) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intervals intervals = other;
            if (intervals instanceof Span) {
                bl = MajorMinor.compareTo-a9gHCQw(((Span)CollectionsKt.first(this.spans)).getFrom-v2ZXzM8(), ((Span)other).getFrom-v2ZXzM8()) >= 0;
            } else if (intervals instanceof Spans) {
                bl = MajorMinor.compareTo-a9gHCQw(((Span)CollectionsKt.first(this.spans)).getFrom-v2ZXzM8(), ((Span)CollectionsKt.first(((Spans)other).spans)).getFrom-v2ZXzM8()) >= 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        @Override
        @NotNull
        public String toString(@NotNull String variable, boolean compact) {
            Span right;
            Span left;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            if (this.spans.size() == 2 && Companion.isNotXInterval(left = this.spans.get(0), right = this.spans.get(1))) {
                return variable + " \u2260 " + MajorMinor.toString-impl(left.getTo-v2ZXzM8());
            }
            return CollectionsKt.joinToString$default((Iterable)this.spans, (CharSequence)" or ", null, null, (int)0, null, (Function1)((Function1)new Function1<Span, CharSequence>(variable, compact){
                final /* synthetic */ String $variable;
                final /* synthetic */ boolean $compact;
                {
                    this.$variable = $variable;
                    this.$compact = $compact;
                    super(1);
                }

                public final CharSequence invoke(Span it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.toString(this.$variable, this.$compact);
                }
            }), (int)30, null);
        }

        @Override
        @NotNull
        public Intervals or(@NotNull Intervals other) {
            Intervals intervals;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intervals intervals2 = other;
            if (intervals2 instanceof Span) {
                intervals = new Spans(Companion.joinIntervals(this.spans, CollectionsKt.listOf((Object)other)));
            } else if (intervals2 instanceof Spans) {
                intervals = new Spans(Companion.joinIntervals(this.spans, ((Spans)other).spans));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return intervals;
        }

        @Override
        @NotNull
        public Intervals and(@NotNull Intervals other) {
            List list;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intervals intervals = other;
            if (intervals instanceof Span) {
                list = Companion.intersectIntervals(this.spans, CollectionsKt.listOf((Object)other));
            } else if (intervals instanceof Spans) {
                list = Companion.intersectIntervals(this.spans, ((Spans)other).spans);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List merged = list;
            return Companion.create(merged);
        }

        @Override
        @NotNull
        public Intervals not() {
            List spans = new ArrayList();
            int prevTo = ZERO;
            for (Span span : this.spans) {
                if (MajorMinor.compareTo-a9gHCQw(span.getFrom-v2ZXzM8(), prevTo) > 0) {
                    spans.add(new Span(prevTo, span.getFrom-v2ZXzM8(), null));
                }
                prevTo = span.getTo-v2ZXzM8();
            }
            if (!MajorMinor.equals-impl0(prevTo, INFINITY)) {
                spans.add(new Span(prevTo, INFINITY, null));
            }
            return Companion.create(spans);
        }

        @Override
        @NotNull
        public String serialize() {
            return CollectionsKt.joinToString$default((Iterable)this.spans, (CharSequence)",", null, null, (int)0, null, (Function1)serialize.1.INSTANCE, (int)30, null);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.Intervals.Spans");
            Spans cfr_ignored_0 = (Spans)other;
            return Intrinsics.areEqual(this.spans, ((Spans)other).spans);
        }

        @Override
        public int hashCode() {
            return this.fromInclusive();
        }
    }
}

